/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ClientEvents;

public class ClientEventsForge
extends ClientEvents {
    public ClientEventsForge(IXaeroMinimap modMain) {
        super(modMain);
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenOpenEvent event) {
        Screen guiBefore = event.getScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            event.setCanceled(true);
            return;
        }
        event.setScreen(gui);
    }

    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.handleRenderGameOverlayEventPre(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.handleRenderGameOverlayEventPost();
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPreLayer(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay() == ForgeIngameGui.POTION_ICONS_ELEMENT && this.handleRenderStatusEffectOverlay(event.getMatrixStack())) {
            event.setCanceled(true);
        }
        if (event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT && this.handleRenderCrosshairOverlay(event.getMatrixStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPostLayer(RenderGameOverlayEvent.PostLayer event) {
        if (event.getOverlay() == ForgeIngameGui.POTION_ICONS_ELEMENT) {
            XaeroMinimapCore.onPotionEffectsRender();
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (this.handleClientSendChatEvent(e.getMessage())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getSenderUUID() == null) {
            if (this.handleClientSystemChatReceivedEvent(e.getMessage())) {
                e.setCanceled(true);
            }
            return;
        }
        if (this.handleClientPlayerChatReceivedEvent(e.getType(), e.getMessage(), e.getSenderUUID())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleRenderWorldLastEvent(RenderLevelLastEvent event) {
        XaeroMinimapCore.onProjectionMatrix(event.getProjectionMatrix());
        XaeroMinimapCore.onWorldModelViewMatrix(event.getPoseStack());
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.DrawScreenEvent.Post event) {
        this.handleDrawScreenEventPost(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        this.worldUnload(event.getWorld());
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleClientTickStart();
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handlePlayerTickStart(event.player);
        }
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleRenderTickStart();
        }
    }
}

