/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui.widget.loader;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.codec.binary.Hex;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import xaero.common.MinimapLogs;
import xaero.common.gui.widget.ImageWidgetBuilder;
import xaero.common.gui.widget.Widget;
import xaero.common.gui.widget.loader.ScalableWidgetLoader;
import xaero.common.misc.Misc;
import xaero.common.platform.Services;

public class ImageWidgetLoader
extends ScalableWidgetLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Widget load(Map<String, String> parsedArgs) throws IOException {
        block32: {
            builder = new ImageWidgetBuilder();
            this.commonLoad(builder, parsedArgs);
            image = parsedArgs.get("image");
            image_url = parsedArgs.get("image_url");
            textureId = 0;
            if (image == null) break block32;
            if (!image.replaceAll("[^a-zA-Z0-9_]+", "").equals(image)) {
                MinimapLogs.LOGGER.info("Invalid widget image id!");
                return null;
            }
            image_md5 = parsedArgs.get("image_md5");
            if (image_md5 == null) {
                MinimapLogs.LOGGER.info("No image md5.");
                RenderSystem.m_69396_((int)0);
                GL11.glDeleteTextures((int)textureId);
                return null;
            }
            try {
                digestMD5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e1) {
                MinimapLogs.LOGGER.info("No algorithm for MD5.");
                RenderSystem.m_69396_((int)0);
                GL11.glDeleteTextures((int)textureId);
                return null;
            }
            builder.setImageId(image);
            textureId = GL11.glGenTextures();
            if (textureId <= 0) {
                return null;
            }
            builder.setGlTexture(textureId);
            RenderSystem.m_69493_();
            RenderSystem.m_69396_((int)textureId);
            tex_base_level = parsedArgs.get("tex_base_level");
            tex_max_level = parsedArgs.get("tex_max_level");
            tex_min_lod = parsedArgs.get("tex_min_lod");
            tex_max_lod = parsedArgs.get("tex_max_lod");
            tex_lod_bias = parsedArgs.get("tex_lod_bias");
            tex_mag_filter = parsedArgs.get("tex_mag_filter");
            tex_min_filter = parsedArgs.get("tex_min_filter");
            tex_wrap_s = parsedArgs.get("tex_wrap_s");
            tex_wrap_t = parsedArgs.get("tex_wrap_t");
            GL11.glTexParameteri((int)3553, (int)33084, (int)(tex_base_level != null ? Integer.parseInt(tex_base_level) : 0));
            GL11.glTexParameteri((int)3553, (int)33085, (int)(tex_max_level != null ? Integer.parseInt(tex_max_level) : 1));
            GL11.glTexParameterf((int)3553, (int)33082, (float)(tex_min_lod != null ? Float.parseFloat(tex_min_lod) : 0.0f));
            GL11.glTexParameterf((int)3553, (int)33083, (float)(tex_max_lod != null ? Float.parseFloat(tex_max_lod) : 1.0f));
            GL11.glTexParameterf((int)3553, (int)34049, (float)(tex_lod_bias != null ? Float.parseFloat(tex_lod_bias) : 0.0f));
            GL11.glTexParameteri((int)3553, (int)10240, (int)(tex_mag_filter != null ? Integer.parseInt(tex_mag_filter) : 9728));
            GL11.glTexParameteri((int)3553, (int)10241, (int)(tex_min_filter != null ? Integer.parseInt(tex_min_filter) : 9729));
            GL11.glTexParameteri((int)3553, (int)10242, (int)(tex_wrap_s != null ? Integer.parseInt(tex_wrap_s) : 33071));
            GL11.glTexParameteri((int)3553, (int)10243, (int)(tex_wrap_t != null ? Integer.parseInt(tex_wrap_t) : 33071));
            cacheFolder = Services.PLATFORM.getGameDir().resolve("XaeroCache").toFile();
            cacheFolderPath = cacheFolder.toPath();
            if (!Files.exists(cacheFolderPath, new LinkOption[0])) {
                Files.createDirectories(cacheFolderPath, new FileAttribute[0]);
            }
            resourceLocation = new ResourceLocation("xaerobetterpvp", "gui/" + image + ".png");
            inputStream = null;
            digestStream = null;
            bufferedImage = null;
            try {
                try {
                    resource = Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation);
                    inputStream = resource.m_6679_();
                    ** GOTO lbl101
                }
                catch (FileNotFoundException e) {
                    MinimapLogs.LOGGER.info("Widget image not included in jar. Checking cache...");
                    cacheFilePath = cacheFolderPath.resolve(image + ".cache");
                    if (Files.exists(cacheFilePath, new LinkOption[0])) ** GOTO lbl99
                    MinimapLogs.LOGGER.info("Widget image not in cache. Downloading...");
                    if (image_url == null) {
                        MinimapLogs.LOGGER.info("No image URL.");
                        RenderSystem.m_69396_((int)0);
                        GL11.glDeleteTextures((int)textureId);
                        var25_29 = null;
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (digestStream != null) {
                            digestStream.close();
                        }
                        return var25_29;
                    }
                    url = new URL(image_url);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(900);
                    conn.setConnectTimeout(900);
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
                    if (conn.getContentLengthLong() > 0x500000L) {
                        throw new IOException("Image too big to trust!");
                    }
                    input = null;
                    output = null;
                    try {
                        input = conn.getInputStream();
                        output = new BufferedOutputStream(new FileOutputStream(cacheFilePath.toFile()));
                        Misc.download((BufferedOutputStream)output, input);
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                    }
                    inputStream = new FileInputStream(cacheFilePath.toFile());
lbl101:
                    // 2 sources

                    inputStream = new BufferedInputStream(inputStream);
                    digestStream = new DigestInputStream(inputStream, digestMD5);
                    bufferedImage = ImageIO.read(digestStream);
                    while (digestStream.read() != -1) {
                    }
                    digest = digestMD5.digest();
                    fileMD5 = Hex.encodeHexString((byte[])digest);
                    if (!image_md5.equals(fileMD5)) {
                        MinimapLogs.LOGGER.info("Invalid image MD5: " + fileMD5);
                        bufferedImage.flush();
                        bufferedImage = null;
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (digestStream != null) {
                    digestStream.close();
                }
            }
            if (bufferedImage == null) {
                RenderSystem.m_69396_((int)0);
                GL11.glDeleteTextures((int)textureId);
                return null;
            }
            imageW = bufferedImage.getWidth();
            imageH = bufferedImage.getHeight();
            buffer = BufferUtils.createByteBuffer((int)(imageW * imageH * 4));
            for (y = 0; y < imageH; ++y) {
                for (x = 0; x < imageW; ++x) {
                    color = bufferedImage.getRGB(x, y);
                    buffer.putInt(color);
                }
            }
            buffer.flip();
            bufferedImage.flush();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)imageW, (int)imageH, (int)0, (int)32993, (int)33639, (ByteBuffer)buffer);
            GL30.glGenerateMipmap((int)3553);
            RenderSystem.m_69396_((int)0);
            builder.setImageW(imageW);
            builder.setImageH(imageH);
        }
        if (builder.validate()) {
            return builder.build();
        }
        if (textureId > 0) {
            GL11.glDeleteTextures((int)textureId);
        }
        return null;
    }
}

