/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.InfoDisplayManager;
import xaero.common.minimap.info.codec.InfoDisplayCommonStateCodecs;
import xaero.common.minimap.info.widget.InfoDisplayCommonWidgetFactories;
import xaero.common.minimap.info.widget.InfoDisplayCycleWidgetFactory;
import xaero.common.minimap.waypoints.WaypointsManager;

public class BuiltInInfoDisplays {
    private static List<InfoDisplay<?>> ALL = new ArrayList();
    public static final InfoDisplay<Boolean> COORDINATES = new InfoDisplay<Boolean>("coords", (Component)new TranslatableComponent("gui.xaero_infodisplay_coords"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        int interfaceSize = size;
        String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
        if (Minecraft.m_91087_().f_91062_.m_92895_(coords) >= interfaceSize) {
            String stringLevel = "" + playerBlockY;
            coords = playerBlockX + ", " + playerBlockZ;
            compiler.addLine(coords);
            compiler.addLine(stringLevel);
        } else {
            compiler.addLine(coords);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> OVERWORLD_COORDINATES = new InfoDisplay<Boolean>("overworld_coords", (Component)new TranslatableComponent("gui.xaero_infodisplay_overworld_coords"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        double coordinateScale = mc.f_91073_.m_6042_().m_63959_();
        if (coordinateScale == 1.0) {
            return;
        }
        int overworldPlayerX = Mth.m_14107_((double)((double)playerBlockX * coordinateScale));
        int overworldPlayerZ = Mth.m_14107_((double)((double)playerBlockZ * coordinateScale));
        String coords = "Xo: " + overworldPlayerX + ", Zo: " + overworldPlayerZ;
        compiler.addWords(size, coords);
    }, ALL);
    public static final InfoDisplay<Boolean> CHUNK_COORDINATES = new InfoDisplay<Boolean>("chunk_coords", (Component)new TranslatableComponent("gui.xaero_infodisplay_chunk_coords"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        int chunkX = playerBlockX >> 4;
        int chunkZ = playerBlockZ >> 4;
        int insideX = playerBlockX & 0xF;
        int insideZ = playerBlockZ & 0xF;
        String coords = "C " + chunkX + ", " + chunkZ + " (" + insideX + "; " + insideZ + ")";
        compiler.addWords(size, coords);
    }, ALL);
    public static final InfoDisplay<Boolean> ANGLES = new InfoDisplay<Boolean>("angles", (Component)new TranslatableComponent("gui.xaero_infodisplay_angles"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        compiler.addLine((Component)new TextComponent(String.format("%.1f / %.1f", Float.valueOf(Mth.m_14177_((float)mc.m_91288_().m_146908_())), Float.valueOf(Mth.m_14177_((float)mc.m_91288_().m_146909_())))));
    }, ALL);
    public static final InfoDisplay<Boolean> DIMENSION = new InfoDisplay<Boolean>("dimension", (Component)new TranslatableComponent("gui.xaero_infodisplay_dimension"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        ResourceLocation dimensionId = Minecraft.m_91087_().f_91073_.m_46472_().m_135782_();
        if (dimensionId != null) {
            String dimensionName = dimensionId.m_135827_().equals("minecraft") ? dimensionId.m_135815_() : dimensionId.toString();
            compiler.addLine(dimensionName);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> BIOME = new InfoDisplay<Boolean>("biome", (Component)new TranslatableComponent("gui.xaero_infodisplay_biome"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Holder biomeHolder = Minecraft.m_91087_().f_91073_.m_204166_(playerPos);
        Biome biome = biomeHolder == null ? null : (Biome)biomeHolder.m_203334_();
        ResourceLocation biomeRL = biome == null ? null : Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
        String biomeText = biomeRL == null ? I18n.m_118938_((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : I18n.m_118938_((String)("biome." + biomeRL.m_135827_() + "." + biomeRL.m_135815_()), (Object[])new Object[0]);
        compiler.addWords(size, biomeText);
    }, ALL);
    public static final InfoDisplay<Boolean> WEATHER = new InfoDisplay<Boolean>("weather", (Component)new TranslatableComponent("gui.xaero_infodisplay_weather"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_.m_46470_()) {
            compiler.addLine((Component)new TranslatableComponent("gui.xaero_weather_thundering"));
        } else if (Minecraft.m_91087_().f_91073_.m_46471_()) {
            compiler.addLine((Component)new TranslatableComponent("gui.xaero_weather_raining"));
        }
    }, ALL);
    public static final InfoDisplay<Integer> LIGHT_LEVEL = new InfoDisplay<Integer>("light_level", (Component)new TranslatableComponent("gui.xaero_infodisplay_light_level"), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.xaero_off"), new TranslatableComponent("gui.xaero_light_block"), new TranslatableComponent("gui.xaero_light_sky"), new TranslatableComponent("gui.xaero_light_all"), new TranslatableComponent("gui.xaero_light_both2")})), (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        int showLightLevel = (Integer)displayInfo.getState();
        if (showLightLevel == 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int blockLight = mc.f_91073_.m_45517_(LightLayer.BLOCK, playerPos);
        int skyLight = mc.f_91073_.m_45517_(LightLayer.SKY, playerPos);
        if (showLightLevel == 1) {
            compiler.addLine((Component)new TranslatableComponent("gui.xaero_block_light_value", new Object[]{blockLight}));
        } else if (showLightLevel == 2) {
            compiler.addLine((Component)new TranslatableComponent("gui.xaero_sky_light_value", new Object[]{skyLight}));
        } else if (showLightLevel == 3) {
            compiler.addLine((Component)new TranslatableComponent("gui.xaero_all_light_value", new Object[]{Math.max(blockLight, skyLight)}));
        } else {
            compiler.addLine((Component)new TranslatableComponent("gui.xaero_both_light_value", new Object[]{blockLight, skyLight}));
        }
    }, ALL);
    public static final InfoDisplay<Integer> TIME = new InfoDisplay<Integer>("time", (Component)new TranslatableComponent("gui.xaero_infodisplay_time"), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.xaero_off"), new TranslatableComponent("%s+%s", new Object[]{new TranslatableComponent("gui.xaero_day"), new TranslatableComponent("gui.xaero_24h")}), new TranslatableComponent("%s+%s", new Object[]{new TranslatableComponent("gui.xaero_day"), new TranslatableComponent("gui.xaero_12h")}), new TranslatableComponent("gui.xaero_24h"), new TranslatableComponent("gui.xaero_12h")})), (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        int showTime = (Integer)displayInfo.getState();
        if (showTime <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        long totalTime = 6000L + mc.f_91073_.m_46468_();
        int dayNumber = (int)(totalTime / 24000L) + 1;
        int dayTimeSinceMidnight = (int)(totalTime % 24000L);
        int timeHours = dayTimeSinceMidnight / 1000;
        int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
        if ((showTime - 1) % 2 == 0) {
            if (showTime < 3) {
                compiler.addWords(size, I18n.m_118938_((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
            } else {
                compiler.addWords(size, String.format("%02d:%02d", timeHours, minutes));
            }
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            if (showTime < 3) {
                compiler.addWords(size, I18n.m_118938_((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
            } else {
                compiler.addWords(size, String.format("%02d:%02d %s", timeHours, minutes, half));
            }
        }
    }, ALL);
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final InfoDisplay<Integer> REAL_TIME = new InfoDisplay<Integer>("real_time", (Component)new TranslatableComponent("gui.xaero_infodisplay_real_time"), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.xaero_off"), new TranslatableComponent("gui.xaero_24h"), new TranslatableComponent("gui.xaero_12h")})), (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        int showTime = (Integer)displayInfo.getState();
        if (showTime <= 0) {
            return;
        }
        CALENDAR.setTimeInMillis(System.currentTimeMillis());
        int timeHours = CALENDAR.get(11);
        int minutes = CALENDAR.get(12);
        if (showTime == 1) {
            compiler.addWords(size, String.format("%02d:%02d IRL", timeHours, minutes));
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            compiler.addWords(size, String.format("%02d:%02d %s IRL", timeHours, minutes, half));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> HIGHLIGHTS = new InfoDisplay<Boolean>("highlights", (Component)new TranslatableComponent("gui.xaero_infodisplay_highlights"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (processor.getMinimapWriter().getDimensionHighlightHandler() != null) {
            processor.getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(compiler, playerBlockX, playerBlockZ, size, true);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> LIGHT_OVERLAY_INDICATOR = new InfoDisplay<Boolean>("light_overlay_indicator", (Component)new TranslatableComponent("gui.xaero_infodisplay_light_overlay_indicator"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (session.getModMain().getSettings().lightOverlayType > 0) {
            compiler.addWords(size, I18n.m_118938_((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> MANUAL_CAVE_MODE_INDICATOR = new InfoDisplay<Boolean>("manual_cave_mode_indicator", (Component)new TranslatableComponent("gui.xaero_infodisplay_manual_cave_mode_indicator"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (processor.isManualCaveMode()) {
            compiler.addWords(size, I18n.m_118938_((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> CUSTOM_SUB_WORLD = new InfoDisplay<Boolean>("custom_sub_world", (Component)new TranslatableComponent("gui.xaero_infodisplay_custom_sub_world"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        WaypointsManager waypointsManager = session.getWaypointsManager();
        if (waypointsManager.getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
            compiler.addWords(size, I18n.m_118938_((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{waypointsManager.getCurrentWorld().getContainer().getSubName()}));
        }
    }, ALL);

    public static void addToManager(InfoDisplayManager manager) {
        ALL.forEach(manager::add);
    }
}

