/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.WaypointDimensionTypeInfo;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldConnectionManager;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsSort;

public class WaypointWorldRootContainer
extends WaypointWorldContainer {
    public boolean configLoaded = false;
    private boolean usingMultiworldDetection = false;
    private boolean ignoreServerLevelId = false;
    private String defaultMultiworldId;
    private boolean teleportationEnabled = true;
    private boolean usingDefaultTeleportCommand = true;
    private String serverTeleportCommandFormat;
    private String serverTeleportCommandRotationFormat;
    private WaypointsSort sortType = WaypointsSort.NONE;
    private boolean sortReversed;
    private boolean ignoreHeightmaps;
    private WaypointWorldConnectionManager subWorldConnections;
    private Map<ResourceKey<Level>, WaypointDimensionTypeInfo> dimensionTypes;

    public WaypointWorldRootContainer(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, String key) {
        super(modMain, minimapSession, key, null);
        this.updateConnectionsField(minimapSession);
        this.dimensionTypes = new HashMap<ResourceKey<Level>, WaypointDimensionTypeInfo>();
    }

    public void updateConnectionsField(XaeroMinimapSession minimapSession) {
        this.subWorldConnections = minimapSession.getWaypointsManager().isMultiplayer(this.key) ? new WaypointWorldConnectionManager() : new WaypointWorldConnectionManager(){

            @Override
            public boolean isConnected(WaypointWorld world1, WaypointWorld world2) {
                return true;
            }

            @Override
            public void save(PrintWriter writer) {
            }
        };
    }

    private File getConfigFile() {
        Path directoryPath = this.getDirectory().toPath();
        try {
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        return directoryPath.resolve("config.txt").toFile();
    }

    public void saveConfig() {
        File configFile = this.getConfigFile();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(configFile));
            writer.println("//waypoints config options");
            writer.println("usingMultiworldDetection:" + this.usingMultiworldDetection);
            writer.println("ignoreServerLevelId:" + this.ignoreServerLevelId);
            if (this.defaultMultiworldId != null) {
                writer.println("defaultMultiworldId:" + this.defaultMultiworldId);
            }
            writer.println("teleportationEnabled:" + this.teleportationEnabled);
            writer.println("usingDefaultTeleportCommand:" + this.usingDefaultTeleportCommand);
            if (this.serverTeleportCommandFormat != null) {
                writer.println("serverTeleportCommandFormat:" + this.serverTeleportCommandFormat.replace(":", "^col^"));
            }
            if (this.serverTeleportCommandRotationFormat != null) {
                writer.println("serverTeleportCommandRotationFormat:" + this.serverTeleportCommandRotationFormat.replace(":", "^col^"));
            }
            writer.println("sortType:" + this.sortType.name());
            writer.println("sortReversed:" + this.sortReversed);
            writer.println("");
            writer.println("//other config options");
            writer.println("ignoreHeightmaps:" + this.ignoreHeightmaps);
            this.subWorldConnections.save(writer);
            writer.println("");
            writer.println("//dimension types (DO NOT EDIT)");
            for (Map.Entry<ResourceKey<Level>, WaypointDimensionTypeInfo> entry : this.dimensionTypes.entrySet()) {
                writer.println("dimensionType:" + entry.getKey().m_135782_().toString().replace(':', '$') + ":" + entry.getValue().toString());
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (writer != null) {
            writer.close();
        }
    }

    public void loadConfig() {
        this.configLoaded = true;
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.saveConfig();
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                String valueString;
                String[] args = line.split(":");
                String string = valueString = args.length < 2 ? "" : args[1];
                if (args[0].equals("usingMultiworldDetection")) {
                    this.usingMultiworldDetection = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("ignoreServerLevelId")) {
                    this.ignoreServerLevelId = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("defaultMultiworldId")) {
                    this.defaultMultiworldId = valueString;
                    continue;
                }
                if (args[0].equals("teleportationEnabled")) {
                    this.teleportationEnabled = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("usingDefaultTeleportCommand")) {
                    this.usingDefaultTeleportCommand = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("teleportCommand")) {
                    this.serverTeleportCommandFormat = "/" + valueString.replace("^col^", ":") + " {x} {y} {z}";
                    this.serverTeleportCommandRotationFormat = "/" + valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
                    continue;
                }
                if (args[0].equals("serverTeleportCommand")) {
                    this.serverTeleportCommandFormat = valueString.replace("^col^", ":") + " {x} {y} {z}";
                    this.serverTeleportCommandRotationFormat = valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
                    continue;
                }
                if (args[0].equals("serverTeleportCommandFormat")) {
                    this.serverTeleportCommandFormat = valueString.replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("serverTeleportCommandRotationFormat")) {
                    this.serverTeleportCommandRotationFormat = valueString.replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("sortType")) {
                    this.sortType = WaypointsSort.valueOf(valueString);
                    continue;
                }
                if (args[0].equals("sortReversed")) {
                    this.sortReversed = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("ignoreHeightmaps")) {
                    this.ignoreHeightmaps = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("connection")) {
                    String worldKey1 = valueString;
                    if (args.length <= 2) continue;
                    String worldKey2 = args[2];
                    this.subWorldConnections.addConnection(worldKey1, worldKey2);
                    continue;
                }
                if (!args[0].equals("dimensionType")) continue;
                try {
                    WaypointDimensionTypeInfo dimType = WaypointDimensionTypeInfo.fromString(args[2], args[3]);
                    if (dimType == null) continue;
                    this.dimensionTypes.put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(args[1].replace('$', ':'))), dimType);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FileNotFoundException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    public boolean isUsingMultiworldDetection() {
        return this.usingMultiworldDetection;
    }

    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.usingMultiworldDetection = usingMultiworldDetection;
    }

    public String getDefaultMultiworldId() {
        return this.defaultMultiworldId;
    }

    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.defaultMultiworldId = defaultMultiworldId;
    }

    public boolean isTeleportationEnabled() {
        return this.teleportationEnabled;
    }

    public void setTeleportationEnabled(boolean teleportation) {
        this.teleportationEnabled = teleportation;
    }

    public boolean isUsingDefaultTeleportCommand() {
        return this.usingDefaultTeleportCommand;
    }

    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.usingDefaultTeleportCommand = usingDefaultTeleportCommand;
    }

    public String getServerTeleportCommandFormat() {
        return this.serverTeleportCommandFormat;
    }

    public String getServerTeleportCommandRotationFormat() {
        return this.serverTeleportCommandRotationFormat;
    }

    public void setServerTeleportCommandFormat(String serverTeleportCommandFormat) {
        this.serverTeleportCommandFormat = serverTeleportCommandFormat;
    }

    public void setServerTeleportCommandRotationFormat(String serverTeleportCommandRotationFormat) {
        this.serverTeleportCommandRotationFormat = serverTeleportCommandRotationFormat;
    }

    public WaypointsSort getSortType() {
        return this.sortType;
    }

    public void toggleSortType() {
        this.sortType = WaypointsSort.values()[(this.sortType.ordinal() + 1) % WaypointsSort.values().length];
    }

    public boolean isSortReversed() {
        return this.sortReversed;
    }

    public void toggleSortReversed() {
        this.sortReversed = !this.sortReversed;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }

    public WaypointWorldConnectionManager getSubWorldConnections() {
        return this.subWorldConnections;
    }

    public boolean isIgnoreHeightmaps() {
        return this.ignoreHeightmaps;
    }

    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.ignoreHeightmaps = ignoreHeightmaps;
    }

    public WaypointDimensionTypeInfo getDimensionType(ResourceKey<Level> dimId) {
        WaypointDimensionTypeInfo dimensionType = this.dimensionTypes.get(dimId);
        if (dimensionType == null) {
            if (dimId == Level.f_46429_) {
                dimensionType = new WaypointDimensionTypeInfo(DimensionType.f_63841_.toString().replace(':', '$'), false, 0.1f, 256, 128, true, false, false, 0.5f, 8.0, false);
            } else if (dimId == Level.f_46428_) {
                dimensionType = new WaypointDimensionTypeInfo(DimensionType.f_63840_.toString().replace(':', '$'), true, 0.0f, 384, 384, false, true, false, 0.0f, 1.0, false);
            } else if (dimId == Level.f_46430_) {
                dimensionType = new WaypointDimensionTypeInfo(DimensionType.f_63842_.toString().replace(':', '$'), false, 0.0f, 256, 256, false, false, true, 0.0f, 1.0, true);
            } else {
                IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
                if (integratedServer == null) {
                    return null;
                }
                ServerLevel serverLevel = integratedServer.m_129880_(dimId);
                if (serverLevel == null) {
                    return null;
                }
                dimensionType = this.getDimTypeInfo(serverLevel.m_6042_());
            }
            this.dimensionTypes.put(dimId, dimensionType);
        }
        return dimensionType;
    }

    public double getDimensionScale(ResourceKey<Level> dimId) {
        WaypointDimensionTypeInfo dimType = this.getDimensionType(dimId);
        if (dimType == null) {
            return 1.0;
        }
        return dimType.getCoordinateScale();
    }

    public void updateDimensionType(ClientLevel level) {
        WaypointDimensionTypeInfo currentDimType;
        ResourceKey dimId = level.m_46472_();
        WaypointDimensionTypeInfo newDimType = this.getDimTypeInfo(level.m_6042_());
        if (!Objects.equals(newDimType, currentDimType = this.dimensionTypes.get(dimId))) {
            this.dimensionTypes.put((ResourceKey<Level>)dimId, newDimType);
            this.saveConfig();
        }
    }

    @Override
    public WaypointWorldRootContainer getRootContainer() {
        return this;
    }

    private WaypointDimensionTypeInfo getDimTypeInfo(DimensionType dimType) {
        DimensionSpecialEffects effects = DimensionSpecialEffects.m_108876_((DimensionType)dimType);
        return new WaypointDimensionTypeInfo(dimType.m_63969_().toString().replace(':', '$'), dimType.m_63935_(), dimType.m_63902_(0), dimType.m_156733_(), dimType.m_63964_(), dimType.m_63969_().equals((Object)DimensionType.f_63841_), dimType.m_63969_().equals((Object)DimensionType.f_63840_), dimType.m_63969_().equals((Object)DimensionType.f_63842_), dimType.m_63904_(6000L), dimType.m_63959_(), effects.m_108884_());
    }
}

