/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.patreon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.codec.binary.Hex;
import xaero.common.MinimapLogs;
import xaero.common.patreon.Patreon;
import xaero.common.patreon.PatreonMod;
import xaero.common.platform.Services;

public class GuiUpdateAll
extends ConfirmScreen {
    public GuiUpdateAll() {
        super(GuiUpdateAll::confirmResult, (Component)new TextComponent("These mods are out-of-date: " + GuiUpdateAll.modListToNames(Patreon.getOutdatedMods())), (Component)new TextComponent(Patreon.getHasAutoUpdates() ? "Would you like to automatically update them?" : "Would you like to update them (open the mod pages)?"));
        Patreon.setNotificationDisplayed(true);
    }

    private static String modListToNames(List<Object> list) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(((PatreonMod)list.get((int)i)).modName);
        }
        return builder.toString();
    }

    public void m_7856_() {
        super.m_7856_();
        if (Patreon.getHasAutoUpdates()) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 120, 200, 20, (Component)new TranslatableComponent("Changelogs", new Object[0]), b -> {
                for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                    PatreonMod mod = (PatreonMod)Patreon.getOutdatedMods().get(i);
                    try {
                        Util.m_137581_().m_137648_(new URI(mod.changelogLink));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }));
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 144, 200, 20, (Component)new TranslatableComponent("Don't show again for these updates", new Object[0]), b -> {
            for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                PatreonMod mod = (PatreonMod)Patreon.getOutdatedMods().get(i);
                if (mod.onVersionIgnore == null) continue;
                mod.onVersionIgnore.run();
            }
            this.f_96541_.m_91152_(null);
        }));
    }

    private static void confirmResult(boolean p_confirmResult_1_) {
        if (p_confirmResult_1_) {
            boolean shouldExit = false;
            if (Patreon.getHasAutoUpdates()) {
                for (GuiEventListener b : Minecraft.m_91087_().f_91080_.m_6702_()) {
                    if (!(b instanceof Button)) continue;
                    ((Button)b).f_93623_ = false;
                }
                shouldExit = GuiUpdateAll.autoUpdate();
            } else {
                shouldExit = true;
                for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                    PatreonMod m = (PatreonMod)Patreon.getOutdatedMods().get(i);
                    try {
                        Util.m_137581_().m_137648_(new URI(m.changelogLink));
                        if (m.modJar == null) continue;
                        Util.m_137581_().m_137644_(m.modJar.getParentFile());
                        continue;
                    }
                    catch (Exception e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                        shouldExit = false;
                    }
                }
            }
            if (shouldExit) {
                Minecraft.m_91087_().m_91395_();
            } else {
                Minecraft.m_91087_().m_91152_(null);
            }
            Minecraft.m_91087_().m_91395_();
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    private static void download(BufferedOutputStream output, InputStream input, boolean closeInput) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        if (closeInput) {
            input.close();
        }
        output.close();
    }

    private static boolean autoUpdate() {
        try {
            MessageDigest digestMD5;
            try {
                digestMD5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e1) {
                MinimapLogs.LOGGER.info("No algorithm for MD5.");
                return false;
            }
            PatreonMod autoupdater = (PatreonMod)Patreon.getMods().get("autoupdater30");
            String jarLink = autoupdater.changelogLink;
            String jarMD5 = autoupdater.latestVersionLayout;
            URL url = new URL(jarLink);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(900);
            conn.setConnectTimeout(900);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
            if (conn.getContentLengthLong() > 0x200000L) {
                throw new IOException("Input too long to trust!");
            }
            InputStream input = conn.getInputStream();
            input = new BufferedInputStream(input);
            DigestInputStream digestInput = new DigestInputStream(input, digestMD5);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(Services.PLATFORM.getGameDir().resolve("xaero_autoupdater.jar").toFile()));
            GuiUpdateAll.download(output, digestInput, true);
            byte[] digest = digestMD5.digest();
            String fileMD5 = Hex.encodeHexString((byte[])digest);
            if (!jarMD5.equals(fileMD5)) {
                MinimapLogs.LOGGER.info("Invalid autoupdater MD5: " + fileMD5);
                return false;
            }
            ArrayList<String> command = new ArrayList<String>();
            Path javaPath = new File(System.getProperty("java.home")).toPath().resolve("bin").resolve("java");
            command.add(javaPath.toString());
            command.add("-jar");
            command.add("./xaero_autoupdater.jar");
            command.add("6");
            command.add(Patreon.getUpdateLocation());
            for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                PatreonMod m = (PatreonMod)Patreon.getOutdatedMods().get(i);
                if (m.modJar == null) continue;
                int canonicalPathAttempts = 10;
                String jarPath = null;
                while (canonicalPathAttempts-- > 0) {
                    try {
                        jarPath = m.modJar.getCanonicalPath();
                        break;
                    }
                    catch (IOException ioe) {
                        MinimapLogs.LOGGER.info("IO exception fetching the canonical path to the mod jar!");
                        if (canonicalPathAttempts == 0) {
                            throw ioe;
                        }
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)ioe);
                        MinimapLogs.LOGGER.info("Retrying... (" + canonicalPathAttempts + ")");
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                command.add(jarPath);
                command.add(m.latestVersionLayout);
                command.add(m.currentVersion.split("_")[1]);
                command.add(m.latestVersion);
                command.add(m.currentVersion.split("_")[0]);
                command.add(m.md5 == null ? "null" : m.md5);
            }
            MinimapLogs.LOGGER.info(String.join((CharSequence)", ", command));
            Runtime.getRuntime().exec(command.toArray(new String[0]));
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            return false;
        }
        return true;
    }
}

