/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client;

import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import potionstudios.byg.client.BYGClient;
import potionstudios.byg.client.config.filebrowser.FileBrowserScreen;

public class BYGForgeClient {
    private static final BiPredicate<Path, ModConfig> FILTER = (relativized, modConfig) -> {
        String regex = "[\\\\|/]";
        return modConfig.getFileName().replaceAll(regex, File.pathSeparator).equals(relativized.toString().replaceAll(regex, File.pathSeparator));
    };

    public static void client() {
        FileBrowserScreen.ON_RELOAD = path -> {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path relativized = configDir.relativize((Path)path);
            ToastComponent toasts = Minecraft.m_91087_().m_91300_();
            ConfigTracker.INSTANCE.fileMap().values().stream().filter(modConfig -> FILTER.test(relativized, (ModConfig)modConfig)).findAny().ifPresentOrElse(modConfig -> {
                try {
                    IConfigEvent.reloading((ModConfig)modConfig);
                    toasts.m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)new TextComponent(String.format("Reloaded %s Config File: ", modConfig.getType().toString())), (Component)new TextComponent(relativized.toString())));
                }
                catch (Exception e) {
                    toasts.m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)new TextComponent(String.format("Reloaded %s Config File FAILED: ", modConfig.getType().toString())), (Component)new TextComponent(relativized.toString() + ": " + e.getMessage())));
                }
            }, () -> toasts.m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)new TextComponent("Config file reloading failed for:"), (Component)new TextComponent(relativized.toString()))));
        };
        FileBrowserScreen.RELOADS_ON_SAVE = fileAbsolutePath -> {
            Path configDir = FMLPaths.CONFIGDIR.get();
            if (fileAbsolutePath.startsWith(configDir)) {
                Path relativized = configDir.relativize((Path)fileAbsolutePath);
                boolean anyMatch = ((Set)ConfigTracker.INSTANCE.configSets().get(ModConfig.Type.CLIENT)).stream().anyMatch(modConfig -> FILTER.test(relativized, (ModConfig)modConfig));
                if (!anyMatch && (Minecraft.m_91087_().m_91090_() || Minecraft.m_91087_().f_91073_ == null)) {
                    return ((Set)ConfigTracker.INSTANCE.configSets().get(ModConfig.Type.COMMON)).stream().anyMatch(modConfig -> FILTER.test(relativized, (ModConfig)modConfig));
                }
                return anyMatch;
            }
            return false;
        };
        BYGClient.registerLayerDefinitions(ForgeHooksClient::registerLayerDefinition);
    }
}

