/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.RadiusMatcher;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class Spike
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public Spike(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (NoisySphereConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoisySphereConfig config) {
        this.setSeed(world.m_7328_(), config.noiseFrequency());
        boolean use2D = random.nextDouble() < config.noise2DChance();
        RadiusMatcher radiusMatcher = config.radiusMatcher();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = (int)((double)radiusSettings.xRadius().m_142270_(random) / 2.0);
        int yRadius = radiusMatcher == RadiusMatcher.ALL ? xRadius : (int)((double)(radiusSettings.yRadius().m_142270_(random) / 2));
        int zRadius = radiusMatcher == RadiusMatcher.ALL || radiusMatcher == RadiusMatcher.XZ ? xRadius : (int)((double)(radiusSettings.zRadius().m_142270_(random) / 2));
        int lowestX = position.m_123341_();
        int lowestY = position.m_123342_();
        int lowestZ = position.m_123343_();
        boolean verifiedHeight = !config.verfiesHeight();
        float perlin = fastNoise.GetPerlin(position.m_123341_(), position.m_123342_(), position.m_123343_());
        double scaledNoise = perlin * 8.0f;
        double centerHeight = Mth.m_14139_((double)scaledNoise, (double)2.0, (double)7.0) + 10.0;
        int stackHeight = config.stackHeight().m_142270_(random);
        int[][] built = new int[xRadius * 2 + 1][zRadius * 2 + 1];
        int stackIDX = 0;
        while (stackIDX <= stackHeight) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                mutable2.m_142451_(mutable.m_123341_() + x);
                double xFract = (double)x / (double)xRadius;
                for (int z = -zRadius; z <= zRadius; ++z) {
                    mutable2.m_142443_(mutable.m_123343_() + z);
                    double zFract = (double)z / (double)zRadius;
                    if (verifiedHeight) {
                        double addedHeight;
                        double d = addedHeight = config.useScaledNoiseHeight() ? this.getScaledNoiseExtensionHeight(mutable2, centerHeight) : 1.0;
                        if (!(addedHeight > (double)built[x + xRadius][z + zRadius])) continue;
                        for (double y = (double)(-yRadius); y <= (double)yRadius; y += 1.0) {
                            double yFract = y / (double)yRadius;
                            mutable2.m_142448_((int)((double)mutable.m_123342_() + y));
                            double distanceSquaredFromCenter = xFract * xFract + yFract * yFract + zFract * zFract;
                            double yDistSquared = yFract * yFract;
                            float noise = use2D ? fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123343_()) : fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_());
                            float threshold = 1.0f + 0.7f * noise;
                            double factor = yDistSquared / (double)threshold;
                            if (factor >= 1.0) {
                                distanceSquaredFromCenter /= factor;
                                distanceSquaredFromCenter -= Math.copySign((double)noise * 0.2, distanceSquaredFromCenter);
                            }
                            double density = stackIDX == stackHeight && config.pointed() ? (y + (double)yRadius + 1.0) / (double)(yRadius * 2 + 1) : 0.0;
                            double squaredDistance = (double)(x * x + z * z) / Mth.m_14085_((double)0.1, (double)1.0, (double)(1.0 - density));
                            if (config.checkSquareDistance() && squaredDistance >= (double)(xRadius * zRadius)) continue;
                            BlockPos.MutableBlockPos mutable3 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable2);
                            int noiseExtensionY = 0;
                            while ((double)noiseExtensionY < addedHeight) {
                                int minY = Math.min(position.m_123342_(), world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutable3.m_123341_(), mutable3.m_123343_()));
                                boolean belowSurfaceDepth = minY - mutable3.m_123342_() < config.belowSurfaceDepth().m_142270_(random);
                                world.m_7731_((BlockPos)mutable3, config.topBlockProvider().m_7112_(random, (BlockPos)mutable3), 2);
                                world.m_7731_(mutable3.m_142300_(Direction.DOWN), config.blockProvider().m_7112_(random, (BlockPos)mutable3), 2);
                                mutable3.m_122173_(Direction.UP);
                                ++noiseExtensionY;
                            }
                            built[x + xRadius][z + zRadius] = Math.max(mutable3.m_123342_(), built[x + xRadius][z + zRadius]);
                            lowestX = Math.min(lowestX, mutable2.m_123341_());
                            lowestY = Math.min(lowestY, mutable2.m_123342_());
                            lowestZ = Math.min(lowestZ, mutable2.m_123343_());
                        }
                        continue;
                    }
                    int oceanFloor = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutable2.m_123341_(), mutable2.m_123343_());
                    if (!world.m_151562_(oceanFloor - 1) && position.m_123342_() - oceanFloor <= 15) continue;
                    return false;
                }
            }
            if (verifiedHeight) {
                mutable.m_142448_(mutable.m_123342_() + yRadius);
                ++stackIDX;
            }
            verifiedHeight = true;
        }
        for (Holder spawningFeature : config.spawningFeatures()) {
            ((PlacedFeature)spawningFeature.m_203334_()).m_191782_(world, chunkGenerator, random, new BlockPos(lowestX, lowestY, lowestZ));
        }
        return true;
    }

    private double getScaledNoiseExtensionHeight(BlockPos.MutableBlockPos mutable2, double centerHeight) {
        float perlin1 = Math.abs(fastNoise.GetPerlin(mutable2.m_123341_(), mutable2.m_123343_()));
        double height = Mth.m_14179_((float)perlin1, (float)2.0f, (float)5.0f);
        return Mth.m_14139_((double)perlin1, (double)height, (double)(centerHeight + 25.0));
    }

    public void setSeed(long seed, float noiseFreq) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Cellular);
            this.seed = seed;
        }
        fastNoise.SetFrequency(noiseFreq);
    }
}

