/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class CragFeature
extends Feature<SimpleBlockProviderConfig> {
    FastNoiseLite fnlPerlin = null;

    public CragFeature(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        SimpleBlockProviderConfig simpleBlockProviderConfig = new SimpleBlockProviderConfig((BlockStateProvider)SimpleStateProvider.m_191382_((Block)Blocks.f_50069_));
        SimpleBlockProviderConfig topBlockProviderConfig = new SimpleBlockProviderConfig((BlockStateProvider)SimpleStateProvider.m_191382_((Block)((Block)BYGBlocks.OVERGROWN_STONE.get())));
        double baseRadius = 10.0;
        double leakage = 0.5;
        int volcanoConeSize = 30;
        int volcanoStartHeight = volcanoConeSize - 5;
        double threshold = 0.4;
        int fluidY = -20 + rand.nextInt(9);
        for (double x = (double)(-volcanoConeSize); x <= (double)volcanoConeSize; x += 1.0) {
            mutable.m_142451_((int)((double)pos.m_123341_() + x));
            for (double z = (double)(-volcanoConeSize); z <= (double)volcanoConeSize; z += 1.0) {
                mutable.m_142443_((int)((double)pos.m_123343_() + z));
                float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.m_123341_(), mutable.m_123343_()));
                int topY = pos.m_123342_();
                int oceanFloorHeight = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutable.m_123341_(), mutable.m_123343_()) - 2;
                for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                    mutable.m_142448_((int)((double)pos.m_123342_() + y + (double)volcanoStartHeight));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (scaledNoise - leakage >= threshold) {
                        if (!(y <= (double)fluidY)) continue;
                        while (mutable.m_123342_() > oceanFloorHeight) {
                            if (mutable.m_123342_() > pos.m_123342_()) {
                                world.m_7731_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), 2);
                                world.m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76193_, 0);
                            } else {
                                world.m_7731_((BlockPos)mutable, Blocks.f_50069_.m_49966_(), 2);
                            }
                            mutable.m_122173_(Direction.DOWN);
                        }
                        continue;
                    }
                    if (!(scaledNoise >= threshold)) continue;
                    int startY = mutable.m_123342_();
                    BlockState movingState = world.m_8055_((BlockPos)mutable);
                    for (int worldY = startY; worldY > oceanFloorHeight && !movingState.m_60815_(); --worldY) {
                        topY = Math.max(mutable.m_123342_(), topY);
                        world.m_7731_((BlockPos)mutable, simpleBlockProviderConfig.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                        mutable.m_122173_(Direction.DOWN);
                    }
                }
                if (topY == pos.m_123342_()) continue;
                mutable.m_142448_(topY);
                if (!world.m_6425_(mutable.m_7949_().m_7494_()).m_76178_()) continue;
                world.m_7731_((BlockPos)mutable, topBlockProviderConfig.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

