/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.arch;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import potionstudios.byg.common.world.feature.BYGFeatures;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.structure.BYGStructurePieceTypes;

public class ArchPiece
extends StructurePiece {
    public static final boolean DEBUG = false;
    private final Set<BlockPos> positions = new HashSet<BlockPos>();
    private final NoisySphereConfig config;

    public ArchPiece(Set<BlockPos> positions, NoisySphereConfig config, int $$1, BoundingBox generatingBB) {
        super(BYGStructurePieceTypes.ARCH_PIECE.get(), $$1, generatingBB);
        this.config = config;
        this.positions.addAll(positions);
    }

    public ArchPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BYGStructurePieceTypes.ARCH_PIECE.get(), tag);
        RegistryOps tagRegistryOps = RegistryOps.m_206821_((DynamicOps)NbtOps.f_128958_, (RegistryAccess)context.f_192763_());
        ListTag positions = tag.m_128437_("positions", 10);
        for (Tag position : positions) {
            this.positions.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)position)));
        }
        this.config = (NoisySphereConfig)((Pair)NoisySphereConfig.CODEC.decode((DynamicOps)tagRegistryOps, (Object)tag.m_128423_("config")).result().orElseThrow()).getFirst();
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        ListTag positions = new ListTag();
        RegistryOps tagRegistryOps = RegistryOps.m_206821_((DynamicOps)NbtOps.f_128958_, (RegistryAccess)context.f_192763_());
        for (BlockPos position : this.positions) {
            positions.add((Object)NbtUtils.m_129224_((BlockPos)position));
        }
        compoundTag.m_128365_("positions", (Tag)positions);
        compoundTag.m_128365_("config", (Tag)NoisySphereConfig.CODEC.encodeStart((DynamicOps)tagRegistryOps, (Object)this.config).result().orElseThrow());
    }

    public void m_183269_(WorldGenLevel worldGenLevel, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        Long2ObjectLinkedOpenHashMap toPlace = new Long2ObjectLinkedOpenHashMap(1000);
        for (BlockPos position : this.positions) {
            if (position.m_123342_() == Integer.MIN_VALUE) {
                position = new BlockPos(position.m_123341_(), worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, position.m_123341_(), position.m_123343_()) + 1, position.m_123343_());
            }
            if (!boundingBox.m_71051_((Vec3i)position)) continue;
            BYGFeatures.BOULDER.get().fillList((Long2ObjectMap<BlockState>)toPlace, worldGenLevel.m_7328_(), random, position, this.config);
        }
        if (toPlace.isEmpty()) {
            return;
        }
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos().m_122178_(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos().m_122178_(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        toPlace.forEach((aLong, state) -> {
            BlockPos pos = BlockPos.m_122022_((long)aLong);
            min.m_122178_(Math.min(min.m_123341_(), pos.m_123341_()), Math.min(min.m_123342_(), pos.m_123342_()), Math.min(min.m_123343_(), pos.m_123343_()));
            max.m_122178_(Math.max(max.m_123341_(), pos.m_123341_()), Math.max(max.m_123342_(), pos.m_123342_()), Math.max(max.m_123343_(), pos.m_123343_()));
            worldGenLevel.m_7731_(pos, state, 2);
        });
        LongBidirectionalIterator longBidirectionalIterator = toPlace.keySet().iterator();
        while (longBidirectionalIterator.hasNext()) {
            long aLong2 = (Long)longBidirectionalIterator.next();
            for (Holder spawningFeature : this.config.spawningFeatures()) {
                ((PlacedFeature)spawningFeature.m_203334_()).m_191782_(worldGenLevel, chunkGenerator, random, BlockPos.m_122022_((long)aLong2));
            }
        }
        int minX = min.m_123341_() - 5;
        int minY = min.m_123342_() - 5;
        int minZ = min.m_123343_() - 5;
        int maxX = max.m_123341_() + 5;
        int maxY = max.m_123342_() + 5;
        int maxZ = max.m_123343_() + 5;
        this.f_73383_ = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

