/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.arch;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import potionstudios.byg.common.world.structure.WithGenerationStep;
import potionstudios.byg.common.world.structure.arch.ArchConfiguration;
import potionstudios.byg.common.world.structure.arch.ArchPiece;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public class ArchStructure
extends StructureFeature<ArchConfiguration>
implements WithGenerationStep {
    public static final int PIECE_BB_EXPANSION = 5;

    public ArchStructure(Codec<ArchConfiguration> $$0) {
        super($$0, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), ArchStructure::generatePieces));
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, PieceGenerator.Context<ArchConfiguration> context) {
        Long2ObjectOpenHashMap newSortedPositions;
        WorldgenRandom random = context.f_192708_();
        double fullRange = Math.PI * 2;
        double ninetyDegrees = fullRange / 4.0;
        double angle = random.nextDouble(fullRange);
        ChunkPos chunkPos = context.f_192705_();
        int blockX = chunkPos.m_151382_(random.nextInt(16));
        int blockZ = chunkPos.m_151391_(random.nextInt(16));
        ChunkGenerator generator = context.f_192703_();
        ArchConfiguration config = (ArchConfiguration)context.f_197328_();
        int length = config.length().m_142270_((Random)random) / 2;
        int archHeight = config.height().m_142270_((Random)random);
        BlockPos center = new BlockPos(blockX, generator.m_142647_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_192707_()) + archHeight, blockZ);
        double xOffset = Math.sin(angle) * (double)length;
        double zOffset = Math.cos(angle) * (double)length;
        Long2ObjectOpenHashMap chunkSortedPositions = new Long2ObjectOpenHashMap();
        float percentageDestroyed = 1.0f - config.percentageDestroyed().m_142269_((Random)random);
        float percentageDestroyed2 = 1.0f - config.percentageDestroyed().m_142269_((Random)random);
        BlockPos start = center.m_142022_(-xOffset, 0.0, -zOffset);
        start = new BlockPos(start.m_123341_(), generator.m_142647_(start.m_123341_(), start.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_192707_()) - 5, start.m_123343_());
        BlockPos end = center.m_142022_(xOffset, 0.0, zOffset);
        end = new BlockPos(end.m_123341_(), generator.m_142647_(end.m_123341_(), end.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_192707_()) - 5, end.m_123343_());
        int points = 1000;
        if (!(config.biomeEnforcement() == ArchConfiguration.EMPTY || ArchStructure.matchesBiome(start, generator, config.biomeEnforcement()) && ArchStructure.matchesBiome(end, generator, config.biomeEnforcement()))) {
            return;
        }
        BlendingFunction blendingFunction = (BlendingFunction)config.blendingFunction().m_146266_((Random)random).orElseThrow();
        BlendingFunction blendingFunction2 = random.nextFloat() < config.matchingBlendingFunctionChance().m_142269_((Random)random) ? blendingFunction : (BlendingFunction)config.blendingFunction().m_146266_((Random)random).orElseThrow();
        BlockPos startToCenterLastPos = null;
        BlockPos endToCenterLastPos = null;
        for (int pointCount = points; pointCount >= 1; --pointCount) {
            double factor = (double)pointCount / (double)points;
            int squareDistance = 2;
            BlockPos startToCenterLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)start.m_123341_(), (double)center.m_123341_()), blendingFunction.apply(factor, start.m_123342_(), center.m_123342_()), Mth.m_14139_((double)factor, (double)start.m_123343_(), (double)center.m_123343_()));
            if (startToCenterLastPos == null || startToCenterLastPos.m_123331_((Vec3i)startToCenterLerpPos) > (double)squareDistance) {
                if (factor > (double)percentageDestroyed) {
                    startToCenterLerpPos = new BlockPos(startToCenterLerpPos.m_123341_(), Integer.MIN_VALUE, startToCenterLerpPos.m_123343_());
                } else {
                    startToCenterLastPos = startToCenterLerpPos;
                }
                long chunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123343_()));
                ((Set)chunkSortedPositions.computeIfAbsent(chunkKey, key -> new HashSet())).add(startToCenterLerpPos);
            }
            BlockPos centerToEndLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)end.m_123341_(), (double)center.m_123341_()), blendingFunction2.apply(factor, end.m_123342_(), center.m_123342_()), Mth.m_14139_((double)factor, (double)end.m_123343_(), (double)center.m_123343_()));
            if (endToCenterLastPos != null && !(endToCenterLastPos.m_123331_((Vec3i)centerToEndLerpPos) > (double)squareDistance)) continue;
            if (factor > (double)percentageDestroyed2) {
                centerToEndLerpPos = new BlockPos(centerToEndLerpPos.m_123341_(), Integer.MIN_VALUE, centerToEndLerpPos.m_123343_());
            } else {
                endToCenterLastPos = centerToEndLerpPos;
            }
            long centerToEndChunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123343_()));
            ((Set)chunkSortedPositions.computeIfAbsent(centerToEndChunkKey, key -> new HashSet())).add(centerToEndLerpPos);
        }
        int width = config.width().m_142270_((Random)random);
        double totalThicknessPoints = (double)width / 3.0;
        if (totalThicknessPoints > 1.0) {
            newSortedPositions = new Long2ObjectOpenHashMap(chunkSortedPositions.size() * (int)totalThicknessPoints);
            ObjectCollection capture = chunkSortedPositions.values();
            double wideXOffset = Math.sin(angle + ninetyDegrees);
            double wideZOffset = Math.cos(angle + ninetyDegrees);
            double widthXOffset = wideXOffset * (double)width;
            double widthZOffset = wideZOffset * (double)width;
            for (Set value : capture) {
                for (BlockPos pos : value) {
                    BlockPos start2 = pos.m_142022_(-widthXOffset, 0.0, -widthZOffset);
                    BlockPos end2 = pos.m_142022_(widthXOffset, 0.0, widthZOffset);
                    for (int thickness = (int)totalThicknessPoints; thickness >= 1; --thickness) {
                        double factor = (double)thickness / totalThicknessPoints;
                        BlockPos startToCenterLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)start2.m_123341_(), (double)pos.m_123341_()), (double)pos.m_123342_(), Mth.m_14139_((double)factor, (double)start2.m_123343_(), (double)pos.m_123343_()));
                        startToCenterLerpPos = new BlockPos(startToCenterLerpPos.m_123341_(), pos.m_123342_(), startToCenterLerpPos.m_123343_());
                        long chunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123343_()));
                        ((Set)newSortedPositions.computeIfAbsent(chunkKey, key -> new HashSet())).add(startToCenterLerpPos);
                        BlockPos centerToEndLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)end2.m_123341_(), (double)pos.m_123341_()), (double)pos.m_123342_(), Mth.m_14139_((double)factor, (double)end2.m_123343_(), (double)pos.m_123343_()));
                        centerToEndLerpPos = new BlockPos(centerToEndLerpPos.m_123341_(), pos.m_123342_(), centerToEndLerpPos.m_123343_());
                        long centerToEndChunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123343_()));
                        ((Set)newSortedPositions.computeIfAbsent(centerToEndChunkKey, key -> new HashSet())).add(centerToEndLerpPos);
                    }
                }
            }
        } else {
            newSortedPositions = chunkSortedPositions;
        }
        newSortedPositions.forEach((offsetChunkPos, set) -> {
            ChunkPos movingChunkPos = new ChunkPos(offsetChunkPos.longValue());
            piecesBuilder.m_142679_((StructurePiece)new ArchPiece((Set<BlockPos>)set, config.sphereConfig(), 0, ArchStructure.getWritableArea(movingChunkPos, context.f_192707_())));
        });
    }

    public static BoundingBox getWritableArea(ChunkPos chunkPos, LevelHeightAccessor accessor) {
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        int k = accessor.m_141937_() + 1;
        int l = accessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    private static boolean matchesBiome(BlockPos pos, ChunkGenerator generator, TagKey<Biome> biomeTagKey) {
        return generator.m_203495_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_())).m_203656_(biomeTagKey);
    }

    @Override
    public GenerationStep.Decoration getDecoration() {
        return GenerationStep.Decoration.RAW_GENERATION;
    }
}

