/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.surfacerules;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.SurfaceRules;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.surfacerules.BYGSurfaceRules;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.jankson.JanksonJsonOps;
import potionstudios.byg.util.jankson.JanksonUtil;

public record SurfaceRulesConfig() {
    public static final Supplier<Map<ResourceKey<LevelStem>, Path>> CONFIG_PATHS = () -> {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        Path surface_rules = ModPlatform.INSTANCE.configPath().resolve("surface_rules");
        map.put(LevelStem.f_63971_, surface_rules.resolve("overworld_surface_rules.json5"));
        map.put(LevelStem.f_63972_, surface_rules.resolve("nether_surface_rules.json5"));
        map.put(LevelStem.f_63973_, surface_rules.resolve("end_surface_rules.json5"));
        return map;
    };
    public static final Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> DEFAULTS = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put((Object)LevelStem.f_63971_, (Object)BYGSurfaceRules.OVERWORLD_SURFACE_RULES);
        map.put((Object)LevelStem.f_63972_, (Object)BYGSurfaceRules.NETHER_SURFACE_RULES);
        map.put((Object)LevelStem.f_63973_, (Object)BYGSurfaceRules.END_SURFACE_RULES);
    });
    public static Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> INSTANCE = null;

    public static Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> getConfig() {
        return SurfaceRulesConfig.getConfig(false, false);
    }

    public static Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = SurfaceRulesConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    private static Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> readConfig(boolean recreate) {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
        CONFIG_PATHS.get().forEach((stemResourceKey, path) -> {
            if (!path.toFile().exists() || recreate) {
                JanksonUtil.createConfig(path, SurfaceRules.RuleSource.f_189682_, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n\nSurface rules in this file are added after data packs load for this dimension(file name is the dimension).\nA guide for surface rules can be found here: https://github.com/TheForsakenFurby/Surface-Rules-Guide-Minecraft-JE-1.18/blob/main/Guide.md\n*/", new HashMap<String, String>(), JanksonJsonOps.INSTANCE, DEFAULTS.get(stemResourceKey));
            }
            BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
            try {
                result.put(stemResourceKey, (Object)((SurfaceRules.RuleSource)JanksonUtil.readConfig(path, SurfaceRules.RuleSource.f_189682_, JanksonJsonOps.INSTANCE)));
            }
            catch (IOException | SyntaxError e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }
}

