/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.surfacerules.rulesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.ticks.ScheduledTick;
import potionstudios.byg.mixin.access.ChunkAccessAccess;
import potionstudios.byg.mixin.access.SurfaceRuleContextAccess;
import potionstudios.byg.mixin.access.SurfaceRulesStateRuleAccess;

public record BlockRuleSourceWithTick(BlockState state, int tickDelay, SurfaceRules.StateRule rule) implements SurfaceRules.RuleSource
{
    public static final Codec<BlockRuleSourceWithTick> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.f_61039_.fieldOf("result_state").forGetter(BlockRuleSourceWithTick::state), (App)Codec.INT.fieldOf("tick_delay").orElse((Object)0).forGetter(BlockRuleSourceWithTick::tickDelay)).apply((Applicative)builder, BlockRuleSourceWithTick::new));

    BlockRuleSourceWithTick(BlockState blockState, int tickDelay) {
        this(blockState, tickDelay, SurfaceRulesStateRuleAccess.byg_create(blockState));
    }

    public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        ChunkAccess chunkAccess = ((SurfaceRuleContextAccess)context).byg_getChunk();
        return (x, y, z) -> {
            BlockState blockState = this.rule.m_183550_(x, y, z);
            LevelHeightAccessor heightAccessor = ((ChunkAccessAccess)chunkAccess).byg_getLevelHeightAccessor();
            if (!(heightAccessor instanceof LevelAccessor)) {
                throw new IllegalStateException("99% sure a mod is doing something cursed and constructing a chunk access without a server level(or some impl of LevelAccessor) and we can't tick our block due to the lack of level data context here.");
            }
            LevelAccessor levelAccessor = (LevelAccessor)heightAccessor;
            BlockPos blockPos = new BlockPos(x, y, z);
            ScheduledTick scheduledTick = new ScheduledTick((Object)blockState.m_60734_(), blockPos, levelAccessor.m_6106_().m_6793_() + (long)this.tickDelay, levelAccessor.m_183596_());
            chunkAccess.m_183531_().m_183393_(scheduledTick);
            FluidState fluidState = blockState.m_60819_();
            if (!fluidState.m_76178_()) {
                ScheduledTick scheduledFluidTick = new ScheduledTick((Object)fluidState.m_76152_(), blockPos, levelAccessor.m_6106_().m_6793_() + (long)this.tickDelay, levelAccessor.m_183596_());
                chunkAccess.m_183526_().m_183393_(scheduledFluidTick);
            }
            return blockState;
        };
    }
}

