/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.surfacerules.rulesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import potionstudios.byg.mixin.access.SurfaceRuleContextAccess;
import potionstudios.byg.util.ChunkRandom;
import potionstudios.byg.util.SeedGetter;

public final class WeightedRuleSource
implements SurfaceRules.RuleSource {
    public static Codec<WeightedRuleSource> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SimpleWeightedRandomList.m_146264_((Codec)SurfaceRules.RuleSource.f_189682_).fieldOf("provider").forGetter(WeightedRuleSource::ruleSources)).apply((Applicative)builder, WeightedRuleSource::new));
    private final SimpleWeightedRandomList<SurfaceRules.RuleSource> ruleSources;

    public WeightedRuleSource(SimpleWeightedRandomList<SurfaceRules.RuleSource> ruleSources) {
        this.ruleSources = ruleSources;
        if (ruleSources.m_146337_()) {
            throw new IllegalStateException("Weighted Rule Source must contain at least 1 value!");
        }
    }

    public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        SurfaceSystem surfaceSystem = ((SurfaceRuleContextAccess)context).byg_getSystem();
        ChunkAccess chunkAccess = ((SurfaceRuleContextAccess)context).byg_getChunk();
        Random random = ((ChunkRandom)chunkAccess).getRandom(((SeedGetter)surfaceSystem).getSeedAsLong());
        SurfaceRules.SurfaceRule[][] rules = new SurfaceRules.SurfaceRule[16][16];
        for (int x2 = 0; x2 < rules.length; ++x2) {
            for (int z2 = 0; z2 < rules[x2].length; ++z2) {
                SurfaceRules.SurfaceRule apply;
                rules[x2][z2] = apply = (SurfaceRules.SurfaceRule)((SurfaceRules.RuleSource)this.ruleSources.m_146266_(random).get()).apply((Object)context);
            }
        }
        return (x, y, z) -> rules[x & 0xF][z & 0xF].m_183550_(x, y, z);
    }

    public SimpleWeightedRandomList<SurfaceRules.RuleSource> ruleSources() {
        return this.ruleSources;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WeightedRuleSource that = (WeightedRuleSource)obj;
        return Objects.equals(this.ruleSources, that.ruleSources);
    }

    public int hashCode() {
        return Objects.hash(this.ruleSources);
    }

    public String toString() {
        return "StateProviderRule[ruleSources=" + this.ruleSources + "]";
    }
}

