/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.network.packet.ConstructBYGPlayerTrackedDataPacket;
import potionstudios.byg.network.packet.DiscoveredBiomesPacket;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.codec.CodecUtil;

public record BYGPlayerTrackedData(Map<String, Set<ResourceKey<Biome>>> discoveredBiomesByNameSpace) {
    public static final Codec<BYGPlayerTrackedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, CodecUtil.BIOME_SET_CODEC).fieldOf("known_biomes").forGetter(bygPlayerTrackedData -> bygPlayerTrackedData.discoveredBiomesByNameSpace)).apply((Applicative)builder, BYGPlayerTrackedData::fromCodec));

    public static BYGPlayerTrackedData fromCodec(Map<String, Set<ResourceKey<Biome>>> discoveredBiomesByNameSpace) {
        return new BYGPlayerTrackedData(new HashMap<String, Set<ResourceKey<Biome>>>(discoveredBiomesByNameSpace));
    }

    public void playerCreate(ServerPlayer player) {
        ModPlatform.INSTANCE.sendToClient(player, new ConstructBYGPlayerTrackedDataPacket(this));
    }

    public void tickPerSecond(ServerPlayer player) {
        ResourceKey biomeResourceKey = (ResourceKey)player.f_19853_.m_204166_(player.m_142538_()).m_203543_().orElseThrow();
        if (this.discoveredBiomesByNameSpace.computeIfAbsent(biomeResourceKey.m_135782_().m_135827_(), key -> new ObjectOpenHashSet()).add(biomeResourceKey)) {
            ModPlatform.INSTANCE.sendToClient(player, new DiscoveredBiomesPacket(this.discoveredBiomesByNameSpace));
        }
    }

    public static interface Access {
        public BYGPlayerTrackedData getPlayerTrackedData();

        public BYGPlayerTrackedData setPlayerTrackedData(BYGPlayerTrackedData var1);
    }
}

