/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import potionstudios.byg.util.codec.CollectionCodec;

public class CodecUtil {
    public static final Codec<ResourceKey<Biome>> BIOME_CODEC = ResourceLocation.f_135803_.comapFlatMap(resourceLocation -> DataResult.success((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)resourceLocation)), ResourceKey::m_135782_);
    public static final Codec<Block> BLOCK_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122824_);
    public static final Codec<Integer> INTEGER_KEY_CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)Integer.valueOf(s)), Object::toString);
    public static final Codec<Item> ITEM_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122827_);
    public static final Codec<MobEffect> MOB_EFFECT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122823_);
    public static final Codec<VillagerProfession> VILLAGER_PROFESSION_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122869_);
    public static final CollectionCodec<ResourceKey<Biome>, Set<ResourceKey<Biome>>> BIOME_SET_CODEC = new CollectionCodec<ResourceKey<Biome>, Set>(BIOME_CODEC, ObjectOpenHashSet::new);

    public static Codec<Integer> intKeyRangeCodec(int min, int max) {
        Function check = Codec.checkRange((Number)min, (Number)max);
        return INTEGER_KEY_CODEC.flatXmap(check, check);
    }

    public static <T> Codec<T> createLoggedExceptionRegistryCodec(Registry<T> registry) {
        return ResourceLocation.f_135803_.comapFlatMap(location -> {
            Optional result = registry.m_6612_(location);
            if (result.isEmpty()) {
                StringBuilder registryElements = new StringBuilder();
                for (int i = 0; i < registry.m_6579_().size(); ++i) {
                    Object object = registry.m_7942_(i);
                    registryElements.append(i).append(". \"").append(registry.m_7981_(object).toString()).append("\"\n");
                }
                return DataResult.error((String)String.format("\"%s\" is not a valid id in registry: %s.\nCurrent Registry Values:\n\n%s\n", location.toString(), registry.toString(), registryElements.toString()));
            }
            return DataResult.success(result.get());
        }, arg_0 -> registry.m_7981_(arg_0));
    }

    public static <T> Codec<WrapForSerialization<T>> wrapCodecForCollectionSerializing(Codec<T> codec) {
        return RecordCodecBuilder.create(builder -> builder.group((App)codec.fieldOf("value").forGetter(tWrapForSerialization -> tWrapForSerialization.value)).apply((Applicative)builder, WrapForSerialization::new));
    }

    public static <T> WrapForSerialization<T> wrap(T toWrap) {
        return new WrapForSerialization<T>(toWrap);
    }

    public record WrapForSerialization<T>(T value) {
    }
}

