/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.jei.EffectBox;
import net.mehvahdjukaar.jeed.jei.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.jei.TabIcon;
import net.mehvahdjukaar.jeed.jei.ingredient.EffectInstanceRenderer;
import net.mehvahdjukaar.jeed.utils.HSLColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class EffectRecipeCategory
implements IRecipeCategory<EffectInfoRecipe> {
    public static final ResourceLocation UID = Jeed.res("effects");
    private static final TabIcon ICON = new TabIcon();
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private static final int yOffset = 12;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final IDrawable effectBackground;
    private final Component localizedName;

    public EffectRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.effectBackground = new EffectBox();
        this.icon = ICON;
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = new TranslatableComponent("jeed.category.effect_info");
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends EffectInfoRecipe> getRecipeClass() {
        return EffectInfoRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(EffectInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        boolean xPos = false;
        int yPos = this.effectBackground.getHeight() + 4 + 12;
        Font font = Minecraft.m_91087_().f_91062_;
        MobEffect effect = recipe.getEffect().m_19544_();
        BaseComponent name = (BaseComponent)effect.m_19482_();
        int color = HSLColor.getProcessedColor(effect.m_19484_());
        name.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131266_((int)color)));
        float x = 80.0f - (float)font.m_92852_((FormattedText)name) / 2.0f;
        font.m_92744_(matrixStack, Language.m_128107_().m_5536_((FormattedText)name), x, 0.0f, -16777216);
        for (FormattedText descriptionLine : recipe.getDescription()) {
            font.m_92877_(matrixStack, Language.m_128107_().m_5536_(descriptionLine), (float)xPos, (float)yPos, -16777216);
            Objects.requireNonNull(font);
            yPos += 9 + 2;
        }
        for (int slotId = 0; slotId < 14; ++slotId) {
            this.slotBackground.draw(matrixStack, (int)(80.0f + 19.0f * ((float)(slotId % 7) - 3.5f)), 125 - 19 * (1 + slotId / 7));
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EffectInfoRecipe recipe, IFocusGroup focuses) {
        int slotId;
        IIngredientType<MobEffectInstance> type = recipe.getEffectIngredientType();
        IRecipeSlotBuilder mainSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 15).setCustomRenderer(type, (IIngredientRenderer)EffectInstanceRenderer.INSTANCE_SLOT).addIngredient(type, (Object)recipe.getEffect());
        IRecipeSlotBuilder second = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 72, 16).addIngredient(type, (Object)recipe.getEffect())).setCustomRenderer(JEIPlugin.EFFECT, (effectInstance, tooltipFlag) -> List.of());
        if (((Boolean)Jeed.EFFECT_BOX.get()).booleanValue()) {
            mainSlot.setBackground(this.effectBackground, -3, -3);
        }
        List<List> slotContents = Arrays.asList(NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_());
        List<ItemStack> compatible = recipe.getInputItems();
        for (slotId = 0; slotId < compatible.size(); ++slotId) {
            slotContents.get(slotId % slotContents.size()).add(compatible.get(slotId));
        }
        for (slotId = 0; slotId < slotContents.size(); ++slotId) {
            int x = 1 + (int)(80.0f + 19.0f * ((float)(slotId % 7) - 3.5f));
            int y = 126 - 19 * (2 - slotId / 7);
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStacks(slotContents.get(slotId));
        }
    }
}

