/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockPickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class RefillUpgradeWrapper
extends UpgradeWrapperBase<RefillUpgradeWrapper, RefillUpgradeItem>
implements IFilteredUpgrade,
ITickableUpgrade,
IBlockPickResponseUpgrade {
    private static final int COOLDOWN = 5;
    private final Map<Integer, TargetSlot> targetSlots;
    private final FilterLogic filterLogic;

    public RefillUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((RefillUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.targetSlots = NBTHelper.getMap((CompoundTag)upgrade.m_41784_(), (String)"targetSlots", Integer::valueOf, (k, tag) -> Optional.of(TargetSlot.fromName(tag.m_7916_()))).orElseGet(HashMap::new);
        if (((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection()) {
            FilterLogic.ObservableFilterItemStackHandler filterHandler = this.filterLogic.getFilterHandler();
            filterHandler.setOnSlotChange(s -> this.onFilterChange(filterHandler, s));
        }
        this.filterLogic.setAllowByDefault(true);
    }

    private void onFilterChange(FilterLogic.ObservableFilterItemStackHandler filterHandler, int slot) {
        if (filterHandler.getStackInSlot(slot).m_41619_()) {
            this.targetSlots.remove(slot);
            this.saveTargetSlots();
        } else if (!this.targetSlots.containsKey(slot)) {
            this.setTargetSlot(slot, TargetSlot.ANY);
        }
    }

    public Map<Integer, TargetSlot> getTargetSlots() {
        return this.targetSlots;
    }

    public void setTargetSlot(int slot, TargetSlot targetSlot) {
        this.targetSlots.put(slot, targetSlot);
        this.saveTargetSlots();
    }

    private void saveTargetSlots() {
        NBTHelper.putMap((CompoundTag)this.upgrade.m_41784_(), (String)"targetSlots", this.targetSlots, String::valueOf, t -> StringTag.m_129297_((String)t.m_7912_()));
        this.save();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (entity == null || this.isInCooldown(world)) {
            return;
        }
        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(playerInvHandler -> InventoryHelper.iterate((IItemHandler)this.filterLogic.getFilterHandler(), (slot, filter) -> {
            if (filter.m_41619_()) {
                return;
            }
            this.tryRefillFilter(entity, (IItemHandler)playerInvHandler, (ItemStack)filter, this.getTargetSlots().getOrDefault(slot, TargetSlot.ANY));
        }));
        this.setCooldown(world, 5);
    }

    private void tryRefillFilter(@Nonnull LivingEntity entity, IItemHandler playerInvHandler, ItemStack filter, TargetSlot targetSlot) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int missingCount = targetSlot.missingCountGetter.getMissingCount(player, playerInvHandler, filter);
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)player.f_36096_.m_142621_(), (ItemStack)filter)) {
            missingCount -= Math.min(missingCount, player.f_36096_.m_142621_().m_41613_());
        }
        if (missingCount == 0) {
            return;
        }
        ITrackedContentsItemHandler extractFromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        ItemStack toMove = filter.m_41777_();
        toMove.m_41764_(missingCount);
        ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toMove, (IItemHandler)extractFromHandler, (boolean)true);
        if (extracted.m_41619_()) {
            return;
        }
        ItemStack remaining = targetSlot.filler.fill(player, playerInvHandler, extracted);
        if (remaining.m_41613_() != extracted.m_41613_()) {
            ItemStack toExtract = extracted.m_41777_();
            toExtract.m_41764_(extracted.m_41613_() - remaining.m_41613_());
            InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)extractFromHandler, (boolean)false);
        }
    }

    public boolean allowsTargetSlotSelection() {
        return ((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection();
    }

    @Override
    public boolean pickBlock(Player player, ItemStack filter) {
        if (!((RefillUpgradeItem)this.upgradeItem).supportsBlockPick()) {
            return false;
        }
        AtomicInteger stashSlot = new AtomicInteger(-1);
        AtomicBoolean hasItemInBackpack = new AtomicBoolean(false);
        ITrackedContentsItemHandler inventoryHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)filter)) {
                hasItemInBackpack.set(true);
                stashSlot.set((int)slot);
            }
        }, () -> stashSlot.get() > -1);
        ItemStack mainHandItem = player.m_21205_();
        ItemStack toExtract = filter.m_41777_();
        toExtract.m_41764_(filter.m_41741_());
        if (hasItemInBackpack.get() && !InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)inventoryHandler, (boolean)true).m_41619_()) {
            if (!(inventoryHandler.getStackInSlot(stashSlot.get()).m_41613_() <= filter.m_41741_() && inventoryHandler.isItemValid(stashSlot.get(), mainHandItem) || inventoryHandler.insertItem(mainHandItem, true).m_41619_())) {
                if (this.canMoveMainHandToInventory(player)) {
                    ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)inventoryHandler, (boolean)false);
                    player.m_21008_(InteractionHand.MAIN_HAND, extracted);
                    player.m_150109_().m_36054_(mainHandItem);
                    return true;
                }
                player.m_5661_((Component)new TranslatableComponent("gui.sophisticatedbackpacks.status.no_space_for_mainhand_item"), true);
                return false;
            }
            ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)inventoryHandler, (boolean)false);
            inventoryHandler.insertItem(mainHandItem, false);
            player.m_21008_(InteractionHand.MAIN_HAND, extracted);
            return true;
        }
        return false;
    }

    private boolean canMoveMainHandToInventory(Player player) {
        int countToAdd = player.m_21205_().m_41613_();
        for (int slot = 0; slot < player.m_150109_().m_6643_() - 5; ++slot) {
            if (slot == player.m_150109_().f_35977_) continue;
            ItemStack slotStack = player.m_150109_().m_8020_(slot);
            if (slotStack.m_41619_()) {
                return true;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slotStack, (ItemStack)player.m_21205_()) || (countToAdd -= slotStack.m_41741_() - slotStack.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public static enum TargetSlot implements StringRepresentable
    {
        ANY("any", (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any", new Object[0]), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any.tooltip", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> InventoryHelper.getCountMissingInHandler((IItemHandler)playerInvHandler, (ItemStack)filter, (int)filter.m_41741_()), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillAnywhereInInventory(playerInvHandler, stackToAdd)),
        MAIN_HAND("main_hand", (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand", new Object[0]), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand.tooltip", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_21205_(), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> ((Player)player).m_21205_(), stackToAdd, stack -> player.m_21008_(InteractionHand.MAIN_HAND, stack))),
        OFF_HAND("off_hand", (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand", new Object[0]), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand.tooltip", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_21206_(), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> ((Player)player).m_21206_(), stackToAdd, stack -> player.m_21008_(InteractionHand.OFF_HAND, stack))),
        TOOLBAR_1("toolbar_1", (Component)new TextComponent("1"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{1}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(0), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(0), stackToAdd, stack -> player.m_150109_().m_6836_(0, stack))),
        TOOLBAR_2("toolbar_2", (Component)new TextComponent("2"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{2}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(1), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(1), stackToAdd, stack -> player.m_150109_().m_6836_(1, stack))),
        TOOLBAR_3("toolbar_3", (Component)new TextComponent("3"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{3}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(2), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(2), stackToAdd, stack -> player.m_150109_().m_6836_(2, stack))),
        TOOLBAR_4("toolbar_4", (Component)new TextComponent("4"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{4}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(3), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(3), stackToAdd, stack -> player.m_150109_().m_6836_(3, stack))),
        TOOLBAR_5("toolbar_5", (Component)new TextComponent("5"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{5}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(4), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(4), stackToAdd, stack -> player.m_150109_().m_6836_(4, stack))),
        TOOLBAR_6("toolbar_6", (Component)new TextComponent("6"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{6}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(5), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(5), stackToAdd, stack -> player.m_150109_().m_6836_(5, stack))),
        TOOLBAR_7("toolbar_7", (Component)new TextComponent("7"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{7}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(6), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(6), stackToAdd, stack -> player.m_150109_().m_6836_(6, stack))),
        TOOLBAR_8("toolbar_8", (Component)new TextComponent("8"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{8}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(7), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(7), stackToAdd, stack -> player.m_150109_().m_6836_(7, stack))),
        TOOLBAR_9("toolbar_9", (Component)new TextComponent("9"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{9}).m_130940_(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.m_150109_().m_8020_(8), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.m_150109_().m_8020_(8), stackToAdd, stack -> player.m_150109_().m_6836_(8, stack)));

        private final String name;
        private final Component acronym;
        private final Component description;
        private final MissingCountGetter missingCountGetter;
        private final Filler filler;
        private static final Map<String, TargetSlot> NAME_VALUES;
        private static final TargetSlot[] VALUES;

        private TargetSlot(String name, Component acronym, Component description, MissingCountGetter missingCountGetter, Filler filler) {
            this.name = name;
            this.acronym = acronym;
            this.description = description;
            this.missingCountGetter = missingCountGetter;
            this.filler = filler;
        }

        public String m_7912_() {
            return this.name;
        }

        public TargetSlot next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public TargetSlot previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        public static TargetSlot fromName(String name) {
            return NAME_VALUES.getOrDefault(name, ANY);
        }

        public Component getAcronym() {
            return this.acronym;
        }

        public Component getDescription() {
            return this.description;
        }

        private static ItemStack refillAnywhereInInventory(IItemHandler playerInvHandler, ItemStack extracted) {
            AtomicReference<ItemStack> remainingStack = new AtomicReference<ItemStack>(extracted);
            InventoryHelper.iterate((IItemHandler)playerInvHandler, (slot, stack) -> {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((ItemStack)remainingStack.get()))) {
                    remainingStack.set(playerInvHandler.insertItem(slot.intValue(), (ItemStack)remainingStack.get(), false));
                }
            }, () -> ((ItemStack)remainingStack.get()).m_41619_());
            ItemStack remaining = remainingStack.get();
            if (!remaining.m_41619_()) {
                ItemStack afterInsert = InventoryHelper.insertIntoInventory((ItemStack)remaining, (IItemHandler)playerInvHandler, (boolean)true);
                if (afterInsert.m_41613_() == remaining.m_41613_()) {
                    return remaining;
                }
                ItemStack toInsert = remaining.m_41777_();
                toInsert.m_41764_(remaining.m_41613_() - afterInsert.m_41613_());
                return InventoryHelper.insertIntoInventory((ItemStack)toInsert, (IItemHandler)playerInvHandler, (boolean)false);
            }
            return remaining;
        }

        private static int getMissingCount(ItemStack stack, ItemStack filter) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)filter)) {
                return filter.m_41741_() - stack.m_41613_();
            }
            return filter.m_41741_();
        }

        private static ItemStack refillSlot(Supplier<ItemStack> getSlotContents, ItemStack stackToAdd, Consumer<ItemStack> setSlotContents) {
            ItemStack contents = getSlotContents.get();
            if (contents.m_41619_()) {
                setSlotContents.accept(stackToAdd);
                return ItemStack.f_41583_;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)contents, (ItemStack)stackToAdd)) {
                contents.m_41769_(stackToAdd.m_41613_());
                return ItemStack.f_41583_;
            }
            return stackToAdd;
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (TargetSlot value : TargetSlot.values()) {
                builder.put((Object)value.m_7912_(), (Object)value);
            }
            NAME_VALUES = builder.build();
            VALUES = TargetSlot.values();
        }

        private static interface MissingCountGetter {
            public int getMissingCount(Player var1, IItemHandler var2, ItemStack var3);
        }

        private static interface Filler {
            public ItemStack fill(Player var1, IItemHandler var2, ItemStack var3);
        }

        private static class Constants {
            private static final String HOTBAR_TRANSL = "refill.target_slot.hotbar.tooltip";

            private Constants() {
            }
        }
    }
}

