/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.config;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> WEAPON_CATEGORIES_SETTING;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ANIMATIONS_SETTING;
    public static final ForgeConfigSpec.ConfigValue<Double> GUARD_SCREEN_SHAKE_MULTIPLY;
    public static final Map<WeaponCategory, Pair<Integer, Float>> hit_stop_by_weapon_categories;
    public static final Map<WeaponCategory, Pair<Integer, Float>> camera_shake_by_weapon_categories;
    public static final Map<Integer, Pair<Integer, Float>> hit_stop_by_animation;
    public static final Map<Integer, Pair<Integer, Float>> camera_shake_by_animation;
    private static final List<String> categories_default_setting;

    public static void load() {
        List hit_stop_by_weapon_categories_list = (List)WEAPON_CATEGORIES_SETTING.get();
        for (String set : hit_stop_by_weapon_categories_list) {
            String[] entry = set.split(" ");
            WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(entry[0]);
            hit_stop_by_weapon_categories.put(weaponCategory, (Pair<Integer, Float>)Pair.of((Object)Integer.parseInt(entry[1]), (Object)Float.valueOf(Float.parseFloat(entry[2]))));
            camera_shake_by_weapon_categories.put(weaponCategory, (Pair<Integer, Float>)Pair.of((Object)Integer.parseInt(entry[3]), (Object)Float.valueOf(Float.parseFloat(entry[4]))));
        }
        List hit_stop_by_animation_list = (List)ANIMATIONS_SETTING.get();
        for (String set : hit_stop_by_animation_list) {
            String[] entry = set.split(" ");
            int animationId = EpicFightMod.getInstance().animationManager.findAnimationByPath(entry[0]).getId();
            hit_stop_by_animation.put(animationId, (Pair<Integer, Float>)Pair.of((Object)Integer.parseInt(entry[1]), (Object)Float.valueOf(Float.parseFloat(entry[2]))));
            camera_shake_by_animation.put(animationId, (Pair<Integer, Float>)Pair.of((Object)Integer.parseInt(entry[3]), (Object)Float.valueOf(Float.parseFloat(entry[4]))));
        }
    }

    static {
        hit_stop_by_weapon_categories = Maps.newHashMap();
        camera_shake_by_weapon_categories = Maps.newHashMap();
        hit_stop_by_animation = Maps.newHashMap();
        camera_shake_by_animation = Maps.newHashMap();
        categories_default_setting = List.of("greatsword 3 0.1 15 2", "longsword 2 0.25 8 1.2", "tachi 2 0.25 8 1.2", "katana 2 0.2 8 1.2", "spear 2 0.2 10 1", "trident 2 0.2 10 1", "sword 2 0.4 8 0.75", "dagger 1 0.6 5 0.5", "fist 2 0.3 10 0.5", "axe 3 0.5 15 1.5", "hoe 2 0.3 8 0.3", "pickaxe 2 0.3 8 0.3", "shield 1 0.2 4 1");
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("weapon categories setting");
        builder.comment(new String[]{"format: weapon_categories hit_stop_duration speed_ratio camera_shake_duration camera_shake_amplitude", "example: greatsword 4 0.1 15 2", "weapon_categories: greatsword, longsword, sword, etc", "hit_stop_duration: duration of hit stop(tick)", "speed_ration: percentage rate, 0.0 - 1.0", "camera_shake_duration: duration of screen shake(tick)", "camera_shake_amplitude: amplitude of screen shake"});
        WEAPON_CATEGORIES_SETTING = builder.defineList("weapon_categories_setting", categories_default_setting, obj -> true);
        builder.pop();
        builder.push("animation setting");
        builder.comment(new String[]{"priority higher than weapon categories setting and override it", "format: attack_animation hit_stop_duration speed_ratio camera_shake_duration camera_shake_amplitude", "example: epicfight:biped/combat/greatsword_dash 4 0 20 5", "attack_animation: modid:path", "hit_stop_duration: duration of hit stop(tick)", "speed_ration: percentage rate, 0.0 - 1.0", "camera_shake_duration: duration of screen shake(tick)", "camera_shake_amplitude: amplitude of screen shake"});
        ANIMATIONS_SETTING = builder.defineList("animation_setting", ArrayList::new, obj -> true);
        builder.pop();
        builder.push("guarding screen shake multiply, based on impact");
        GUARD_SCREEN_SHAKE_MULTIPLY = builder.defineInRange("multiply", 1.0, 0.0, 10.0);
        builder.pop();
        SPEC = builder.build();
    }
}

