/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.oil;

import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MobOilEffect
extends OilEffect {
    private final MobEffect mobEffect;
    private final int effectDuration;
    private final int effectLevel;

    public MobOilEffect(String nameIn, int colorIn, int maxUsesIn, float damageModifierIn, OilEffect.IUsePredicate usePredicateIn, MobEffect mobEffectIn, int effectDurationIn, int effectLevelIn) {
        super(nameIn, colorIn, maxUsesIn, damageModifierIn, usePredicateIn);
        this.mobEffect = mobEffectIn;
        this.effectDuration = effectDurationIn;
        this.effectLevel = effectLevelIn;
    }

    public MobOilEffect(String nameIn, int colorIn, int maxUsesIn, MobEffect mobEffectIn, int effectDurationIn, int effectLevelIn) {
        this(nameIn, colorIn, maxUsesIn, 0.0f, OilEffect.USE_NOTHING, mobEffectIn, effectDurationIn, effectLevelIn);
    }

    @Override
    public float onUse(float baseDamageIn, Level levelIn, LivingEntity targetIn, LivingEntity userIn, ItemStack oilStackIn) {
        targetIn.m_147207_(new MobEffectInstance(this.mobEffect, this.effectDuration, this.effectLevel), (Entity)userIn);
        return super.onUse(baseDamageIn, levelIn, targetIn, userIn, oilStackIn);
    }

    @Override
    public void getTooltip(ItemStack stackIn, List<Component> tooltipListIn) {
        MutableComponent mobEffectComponent = this.mobEffect.m_19482_().m_6881_().m_130940_(ChatFormatting.YELLOW);
        if (this.effectLevel > 0) {
            mobEffectComponent.m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + Integer.toString(this.effectLevel + 1)));
        }
        if (this.damageModifier == 0.0f) {
            tooltipListIn.add((Component)new TranslatableComponent("tooltip.spartanweaponry.weapon_oil.applied." + this.name, new Object[]{mobEffectComponent, Float.valueOf((float)this.effectDuration / 20.0f)}).m_130940_(ChatFormatting.BLUE));
        } else {
            tooltipListIn.add((Component)new TranslatableComponent("tooltip.spartanweaponry.weapon_oil.applied." + this.name, new Object[]{Float.valueOf(this.getDamageModifier() * 100.0f), mobEffectComponent, Float.valueOf((float)this.effectDuration / 20.0f)}).m_130940_(ChatFormatting.BLUE));
        }
    }
}

