/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.oil;

import com.oblivioussp.spartanweaponry.api.tags.ModEntityTypeTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class OilEffect
extends ForgeRegistryEntry<OilEffect> {
    public static final IUsePredicate USE_NOTHING = (baseDamage, effect, level, target, user) -> false;
    public static final IUsePredicate USE_UNDEAD = (baseDamage, effect, level, target, user) -> target.m_6336_() == MobType.f_21641_;
    public static final IUsePredicate USE_ARTHROPOD = (baseDamage, effect, level, target, user) -> target.m_6336_() == MobType.f_21642_;
    public static final IUsePredicate USE_CRYOTIC = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(EntityTypeTags.f_144295_);
    public static final IUsePredicate USE_NECTROTIC = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(ModEntityTypeTags.HUMANOIDS);
    public static final IUsePredicate USE_CREEPER = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(ModEntityTypeTags.CREEPERS);
    public static final IUsePredicate USE_AQUATIC = (baseDamage, effect, level, target, user) -> target.m_6336_() == MobType.f_21644_;
    public static final IUsePredicate USE_ENDER = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(ModEntityTypeTags.ENDER);
    protected final String name;
    protected final int color;
    protected final int maxUses;
    protected final float damageModifier;
    protected final IUsePredicate usePredicate;
    protected final boolean isPotionOil;

    public OilEffect(String nameIn, int colorIn, int maxUsesIn, float damageModifierIn, IUsePredicate usePredicateIn, boolean isPotionOilIn) {
        this.name = nameIn;
        this.color = colorIn;
        this.maxUses = maxUsesIn;
        this.damageModifier = damageModifierIn;
        this.usePredicate = usePredicateIn;
        this.isPotionOil = isPotionOilIn;
    }

    public OilEffect(String nameIn, int colorIn, int maxUsesIn, float damageModifierIn, IUsePredicate usePredicateIn) {
        this(nameIn, colorIn, maxUsesIn, damageModifierIn, usePredicateIn, false);
    }

    public String getName() {
        return this.name;
    }

    public int getColor(ItemStack stackIn) {
        return this.color;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public float getDamageModifier() {
        return this.damageModifier;
    }

    public float onUse(float baseDamageIn, Level levelIn, LivingEntity targetEntityIn, LivingEntity userEntityIn, ItemStack oilStackIn) {
        return this.usePredicate.test(baseDamageIn, this, levelIn, targetEntityIn, userEntityIn) ? baseDamageIn + baseDamageIn * this.getDamageModifier() : baseDamageIn;
    }

    public void getTooltip(ItemStack stackIn, List<Component> tooltipListIn) {
        tooltipListIn.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltipListIn.add((Component)new TranslatableComponent("tooltip.spartanweaponry.weapon_oil.applied." + this.getName(), new Object[]{Float.valueOf(this.getDamageModifier() * 100.0f)}).m_130940_(ChatFormatting.BLUE));
    }

    @FunctionalInterface
    public static interface IUsePredicate {
        public boolean test(float var1, OilEffect var2, Level var3, LivingEntity var4, LivingEntity var5);
    }
}

