/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.IActionTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class HarvesterWeaponTrait
extends WeaponTrait
implements IActionTraitCallback {
    public HarvesterWeaponTrait(String typeIn, String modIdIn) {
        super(typeIn, modIdIn, WeaponTrait.TraitQuality.POSITIVE);
    }

    @Override
    public Optional<IActionTraitCallback> getActionCallback() {
        return Optional.of(this);
    }

    @Override
    public InteractionResult useOn(UseOnContext contextIn) {
        Level level = contextIn.m_43725_();
        BlockPos clickedPos = contextIn.m_8083_();
        Player player = contextIn.m_43723_();
        if (!level.f_46443_) {
            AtomicBoolean applyCooldown = new AtomicBoolean(false);
            BlockPos.m_121976_((int)(clickedPos.m_123341_() - 1), (int)clickedPos.m_123342_(), (int)(clickedPos.m_123343_() - 1), (int)(clickedPos.m_123341_() + 1), (int)clickedPos.m_123342_(), (int)(clickedPos.m_123343_() + 1)).forEach(pos -> {
                if (this.harvestCrops(level, player, contextIn.m_43722_(), (BlockPos)pos)) {
                    applyCooldown.set(true);
                }
            });
            if (applyCooldown.get()) {
                player.m_21011_(contextIn.m_43724_(), true);
                player.m_36335_().m_41524_(contextIn.m_43722_().m_41720_(), 10);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack usingStackIn, Level levelIn, Player playerIn, InteractionHand handIn) {
        return InteractionResultHolder.m_19098_((Object)usingStackIn);
    }

    public boolean harvestCrops(Level levelIn, Player playerIn, ItemStack toolIn, BlockPos posIn) {
        BlockState state = levelIn.m_8055_(posIn);
        Block block = state.m_60734_();
        if (block instanceof CropBlock || state.m_60713_(Blocks.f_50200_)) {
            IntegerProperty ageProp = (IntegerProperty)state.m_61147_().stream().filter(prop -> prop.m_61708_() == "age").findFirst().orElseThrow();
            int maxAge = (Integer)Collections.max(ageProp.m_6908_());
            if ((Integer)state.m_61143_((Property)ageProp) >= maxAge) {
                List drops = state.m_60724_(new LootContext.Builder((ServerLevel)levelIn).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)posIn)).m_78972_(LootContextParams.f_81461_, (Object)state).m_78972_(LootContextParams.f_81455_, (Object)playerIn).m_78972_(LootContextParams.f_81463_, (Object)toolIn));
                ItemStack targetSeed = block.m_7397_((BlockGetter)levelIn, posIn, state);
                for (ItemStack dropStack : drops) {
                    if (!dropStack.m_150930_(targetSeed.m_41720_())) continue;
                    dropStack.m_41774_(1);
                    break;
                }
                drops.forEach(stack -> Block.m_49840_((Level)levelIn, (BlockPos)posIn, (ItemStack)stack));
                levelIn.m_46597_(posIn, (BlockState)state.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(0)));
                SoundType blockSound = block.getSoundType(state, (LevelReader)levelIn, posIn, null);
                levelIn.m_5594_(null, posIn, blockSound.m_56775_(), SoundSource.BLOCKS, blockSound.m_56773_(), blockSound.m_56774_());
                return true;
            }
        }
        return false;
    }
}

