/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.oblivioussp.spartanweaponry.item.IHudCrosshair;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;

public class HudCrosshair {
    public static final ResourceLocation CROSSHAIR_TEXTURES = new ResourceLocation("spartanweaponry", "textures/gui/crosshairs.png");

    public static void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        Options options = mc.f_91066_;
        LocalPlayer player = mc.f_91074_;
        ItemStack equipStack = ItemStack.f_41583_;
        if (player.m_21205_().m_41720_() instanceof IHudCrosshair) {
            equipStack = player.m_21205_();
        } else if (player.m_21211_().m_41720_() instanceof IHudCrosshair) {
            equipStack = player.m_21211_();
        }
        if (equipStack.m_41619_()) {
            if (!OverlayRegistry.getEntry((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT).isEnabled()) {
                OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)true);
            }
            return;
        }
        IHudCrosshair crosshairItem = (IHudCrosshair)equipStack.m_41720_();
        if (crosshairItem.getCrosshairHudElement() != null) {
            if (OverlayRegistry.getEntry((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT).isEnabled()) {
                OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)false);
            }
            if (options.m_92176_().m_90612_() && (mc.f_91072_.m_105295_() != GameType.SPECTATOR || HudCrosshair.canRenderCrosshairForSpectator(mc))) {
                if (options.f_92063_ && !options.f_92062_ && !player.m_36330_() && !options.f_92047_) {
                    Camera camera = mc.f_91063_.m_109153_();
                    PoseStack posestack = RenderSystem.m_157191_();
                    posestack.m_85836_();
                    posestack.m_85837_((double)(screenWidth / 2), (double)(screenHeight / 2), (double)gui.m_93252_());
                    posestack.m_85845_(Vector3f.f_122222_.m_122240_(camera.m_90589_()));
                    posestack.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_()));
                    posestack.m_85841_(-1.0f, -1.0f, -1.0f);
                    RenderSystem.m_157182_();
                    RenderSystem.m_69881_((int)10);
                    posestack.m_85849_();
                    RenderSystem.m_157182_();
                } else {
                    crosshairItem.getCrosshairHudElement().render(gui, mStack, partialTicks, screenWidth, screenHeight, equipStack);
                }
            }
        }
    }

    private static boolean canRenderCrosshairForSpectator(Minecraft mc) {
        HitResult hitResult = mc.f_91077_;
        if (hitResult == null) {
            return false;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_() instanceof MenuProvider;
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            ClientLevel level = mc.f_91073_;
            BlockPos blockpos = ((BlockHitResult)hitResult).m_82425_();
            return level.m_8055_(blockpos).m_60750_((Level)level, blockpos) != null;
        }
        return false;
    }
}

