/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.common.util.LazyOptional;

public class OilCoatingItemBakedModel
extends ItemMultiLayerBakedModel {
    private final ImmutableList<Pair<BakedModel, RenderType>> coatedLayerModels;

    public OilCoatingItemBakedModel(boolean smoothLighting, boolean shadedInGui, boolean sideLit, TextureAtlasSprite particle, ItemOverrides overrides, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms, ImmutableList<Pair<BakedModel, RenderType>> layerModels, Pair<BakedModel, RenderType> coatingLayerModel) {
        super(smoothLighting, shadedInGui, sideLit, particle, overrides, cameraTransforms, layerModels);
        ImmutableList.Builder coatedBuilder = ImmutableList.builder();
        coatedBuilder.addAll(layerModels);
        coatedBuilder.add(coatingLayerModel);
        this.coatedLayerModels = coatedBuilder.build();
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        LazyOptional lazyHandler = itemStack.getCapability(ModCapabilities.OIL_CAPABILITY);
        return lazyHandler.isPresent() && ((IOilHandler)lazyHandler.resolve().get()).isOiled() ? this.coatedLayerModels : super.getLayerModels(itemStack, fabulous);
    }

    public static Builder makeBuilder(IModelConfiguration ownerIn, TextureAtlasSprite particleTextureIn, ItemOverrides overridesIn, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransformsIn) {
        return new Builder(ownerIn, particleTextureIn, overridesIn, cameraTransformsIn);
    }

    public static class Builder {
        private final ImmutableList.Builder<Pair<BakedModel, RenderType>> layerBuilder = ImmutableList.builder();
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private final ItemOverrides overrides;
        private final ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms;
        private final IModelConfiguration owner;
        private TextureAtlasSprite particleTexture;
        private RenderType lastRenderType;
        private Pair<BakedModel, RenderType> coatedLayer;

        private Builder(IModelConfiguration ownerIn, TextureAtlasSprite particleTextureIn, ItemOverrides overridesIn, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransformsIn) {
            this.owner = ownerIn;
            this.particleTexture = particleTextureIn;
            this.overrides = overridesIn;
            this.cameraTransforms = cameraTransformsIn;
        }

        private void addLayer(ImmutableList.Builder<Pair<BakedModel, RenderType>> layerBuilderIn, List<BakedQuad> quadsIn, RenderType renderTypeIn) {
            BakedItemModel model = new BakedItemModel(ImmutableList.copyOf(quadsIn), this.particleTexture, ImmutableMap.of(), ItemOverrides.f_111734_, true, this.owner.isSideLit());
            layerBuilderIn.add((Object)Pair.of((Object)model, (Object)renderTypeIn));
        }

        private void flushQuads(RenderType renderTypeIn) {
            if (renderTypeIn != this.lastRenderType) {
                if (this.quads.size() > 0) {
                    this.addLayer(this.layerBuilder, this.quads, this.lastRenderType);
                    this.quads.clear();
                }
                this.lastRenderType = renderTypeIn;
            }
        }

        public Builder addQuads(RenderType renderTypeIn, Collection<BakedQuad> quadsIn) {
            this.flushQuads(renderTypeIn);
            this.quads.addAll(quadsIn);
            return this;
        }

        public Builder addCoatingQuads(RenderType renderTypeIn, Collection<BakedQuad> quadsIn) {
            if (this.coatedLayer == null) {
                BakedItemModel coatingModel = new BakedItemModel(ImmutableList.copyOf(quadsIn), this.particleTexture, ImmutableMap.of(), ItemOverrides.f_111734_, true, this.owner.isSideLit());
                this.coatedLayer = Pair.of((Object)coatingModel, (Object)renderTypeIn);
            } else {
                Log.error("Failed to add coating quads for model '" + this.owner.getModelName() + "'; Coating quads have already been added!");
            }
            return this;
        }

        public OilCoatingItemBakedModel build() {
            if (this.quads.size() > 0) {
                this.addLayer(this.layerBuilder, this.quads, this.lastRenderType);
            }
            return new OilCoatingItemBakedModel(this.owner.useSmoothLighting(), this.owner.isShadedInGui(), this.owner.isSideLit(), this.particleTexture, this.overrides, this.cameraTransforms, (ImmutableList<Pair<BakedModel, RenderType>>)this.layerBuilder.build(), this.coatedLayer);
        }
    }
}

