/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class OilParser {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OIL_EFFECT = new DynamicCommandExceptionType(object -> new TranslatableComponent("command.spartanweaponry.apply_oil.error.unknown_oil_effect", new Object[]{object}));
    public static final DynamicCommandExceptionType ERROR_INVALID_OIL_EFFECT = new DynamicCommandExceptionType(object -> new TranslatableComponent("command.spartanweaponry.apply_oil.error.invalid_oil_effect", new Object[]{object}));
    private static final BiFunction<SuggestionsBuilder, IForgeRegistry<OilEffect>, CompletableFuture<Suggestions>> SUGGEST_NOTHING = (builder, registry) -> builder.buildFuture();
    private final StringReader reader;
    @Nullable
    private OilEffect oilEffect;
    private BiFunction<SuggestionsBuilder, IForgeRegistry<OilEffect>, CompletableFuture<Suggestions>> suggestionFunc;

    public OilParser(StringReader readerIn) {
        this.reader = readerIn;
    }

    @Nullable
    public OilEffect getEffect() {
        return this.oilEffect;
    }

    public void read() throws CommandSyntaxException {
        int idx = this.reader.getCursor();
        ResourceLocation loc = ResourceLocation.m_135818_((StringReader)this.reader);
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        this.oilEffect = (OilEffect)registry.getValue(loc);
        if (this.oilEffect == null) {
            this.reader.setCursor(idx);
            throw ERROR_UNKNOWN_OIL_EFFECT.createWithContext((ImmutableStringReader)this.reader, (Object)loc.toString());
        }
        if (this.oilEffect == OilEffects.NONE.get()) {
            this.reader.setCursor(idx);
            throw ERROR_INVALID_OIL_EFFECT.createWithContext((ImmutableStringReader)this.reader, (Object)loc.toString());
        }
    }

    public OilParser parse() throws CommandSyntaxException {
        this.suggestionFunc = this::suggestOilEffect;
        this.read();
        this.suggestionFunc = SUGGEST_NOTHING;
        return this;
    }

    private CompletableFuture<Suggestions> suggestOilEffect(SuggestionsBuilder builderIn, IForgeRegistry<OilEffect> oilRegistryIn) {
        Set suggestions = oilRegistryIn.getKeys().stream().filter(oil -> oil != ((OilEffect)((Object)((Object)OilEffects.NONE.get()))).getRegistryName() || oil != ((OilEffect)((Object)((Object)OilEffects.POTION.get()))).getRegistryName()).collect(Collectors.toSet());
        return SharedSuggestionProvider.m_82926_(suggestions, (SuggestionsBuilder)builderIn);
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builderIn, IForgeRegistry<OilEffect> oilRegistryIn) {
        return this.suggestionFunc.apply(builderIn.createOffset(this.reader.getCursor()), oilRegistryIn);
    }
}

