/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionParser {
    private static final ImmutableList<Potion> invalidPotions = ImmutableList.of((Object)Potions.f_43598_, (Object)Potions.f_43599_, (Object)Potions.f_43600_, (Object)Potions.f_43601_, (Object)Potions.f_43602_);
    private static final List<ResourceLocation> invalidPotionNames = invalidPotions.stream().map(potion -> ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)potion)).collect(Collectors.toUnmodifiableList());
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_POTION = new DynamicCommandExceptionType(object -> new TranslatableComponent("command.spartanweaponry.apply_oil.error.unknown_potion", new Object[]{object}));
    public static final DynamicCommandExceptionType ERROR_INVALID_POTION = new DynamicCommandExceptionType(object -> new TranslatableComponent("command.spartanweaponry.apply_oil.error.invalid_potion", new Object[]{object}));
    private static final BiFunction<SuggestionsBuilder, IForgeRegistry<Potion>, CompletableFuture<Suggestions>> SUGGEST_NOTHING = (builder, registry) -> builder.buildFuture();
    private final StringReader reader;
    @Nullable
    private Potion potion;
    private BiFunction<SuggestionsBuilder, IForgeRegistry<Potion>, CompletableFuture<Suggestions>> suggestionFunc;

    public PotionParser(StringReader readerIn) {
        this.reader = readerIn;
    }

    @Nullable
    public Potion getEffect() {
        return this.potion;
    }

    public void read() throws CommandSyntaxException {
        int idx = this.reader.getCursor();
        ResourceLocation loc = ResourceLocation.m_135818_((StringReader)this.reader);
        this.potion = (Potion)ForgeRegistries.POTIONS.getValue(loc);
        if (this.potion == null) {
            this.reader.setCursor(idx);
            throw ERROR_UNKNOWN_POTION.createWithContext((ImmutableStringReader)this.reader, (Object)loc.toString());
        }
        if (invalidPotions.contains((Object)this.potion)) {
            this.reader.setCursor(idx);
            throw ERROR_INVALID_POTION.createWithContext((ImmutableStringReader)this.reader, (Object)loc.toString());
        }
    }

    public PotionParser parse() throws CommandSyntaxException {
        this.suggestionFunc = this::suggestPotionEffect;
        this.read();
        this.suggestionFunc = SUGGEST_NOTHING;
        return this;
    }

    private CompletableFuture<Suggestions> suggestPotionEffect(SuggestionsBuilder builderIn, IForgeRegistry<Potion> potionRegistryIn) {
        Set suggestions = potionRegistryIn.getKeys().stream().filter(potion -> !invalidPotionNames.contains(potion)).collect(Collectors.toSet());
        return SharedSuggestionProvider.m_82926_(suggestions, (SuggestionsBuilder)builderIn);
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builderIn, IForgeRegistry<Potion> oilRegistryIn) {
        return this.suggestionFunc.apply(builderIn.createOffset(this.reader.getCursor()), oilRegistryIn);
    }
}

