/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.compat.jei;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.item.crafting.OilBrewingRecipe;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.List;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Unmodifiable;

public class JeiOilBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> baseOils;
    private final List<ItemStack> ingredients;
    private final ItemStack output;
    private int brewingSteps = Integer.MAX_VALUE;

    public JeiOilBrewingRecipe(List<ItemStack> baseOilsIn, List<ItemStack> ingredientsIn, ItemStack outputIn) {
        this.baseOils = ImmutableList.copyOf(baseOilsIn);
        this.ingredients = ImmutableList.copyOf(ingredientsIn);
        this.output = outputIn;
    }

    public @Unmodifiable List<ItemStack> getPotionInputs() {
        return this.baseOils;
    }

    public @Unmodifiable List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getPotionOutput() {
        return this.output;
    }

    public int getBrewingSteps() {
        if (this.brewingSteps == Integer.MAX_VALUE) {
            OilEffect oilEffect = OilHelper.getOilFromStack(this.output);
            this.brewingSteps = OilBrewingRecipe.getBrewingSteps(oilEffect);
        }
        return this.brewingSteps;
    }
}

