/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class BoomerangEntity
extends ThrowingWeaponEntity {
    protected final String NBT_RETURN_POSITION = "ReturnPosition";
    protected final String NBT_X = "X";
    protected final String NBT_Y = "Y";
    protected final String NBT_Z = "Z";
    protected final String NBT_RETURNING = "Returning";
    protected final String NBT_DISTANCE_TO_RETURN = "DistanceToReturn";
    public static final double DISTANCE_TO_RETURN = 5.0;
    protected final double MAX_VELOCITY = 2.0;
    protected final double ACCELERATION = 0.1;
    protected final int TICKS_PER_SOUND = 5;
    protected Vec3 returnPos = null;
    protected boolean isReturning = false;
    protected double maxDistance = 5.0;
    protected int ticksUntilSound = 0;
    protected boolean affectedByWaterDrag = true;
    protected int caughtItems = 0;
    protected static final Predicate<Entity> ITEMS_AND_XP = EntitySelector.f_20408_.and(entity -> entity.m_6095_() == EntityType.f_20570_ || entity instanceof ItemEntity);

    public BoomerangEntity(EntityType<? extends ThrowingWeaponEntity> type, Level level) {
        super(type, level);
        this.initEntity();
    }

    public BoomerangEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends ThrowingWeaponEntity>)((EntityType)ModEntities.BOOMERANG.get()), level, x, y, z);
        this.initEntity();
    }

    public BoomerangEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends ThrowingWeaponEntity>)((EntityType)ModEntities.BOOMERANG.get()), shooter, level);
        this.initEntity();
    }

    public BoomerangEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends ThrowingWeaponEntity>)((EntityType)ModEntities.BOOMERANG.get()), level);
        this.initEntity();
    }

    protected void initEntity() {
        this.m_20242_(true);
    }

    protected void setReturnPosition(Entity shooter) {
        if (shooter != null) {
            this.returnPos = new Vec3(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() * 0.9 - 0.1, shooter.m_20189_());
        }
    }

    public void setDistanceToReturn(double distance) {
        this.maxDistance = distance;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            return;
        }
        this.setReturnPosition(this.m_37282_());
        double distance = -1.0;
        if (this.returnPos != null) {
            distance = this.returnPos.m_82554_(this.m_20182_());
        }
        if (this.m_20068_()) {
            AABB aabb;
            List catchableEntities;
            if (distance < 1.0 && this.isReturning || this.m_20069_() && this.waterInertia <= 0.0f || this.returnPos == null) {
                this.m_20242_(false);
            }
            if (distance > this.maxDistance && !this.isReturning) {
                this.isReturning = true;
            }
            if (this.isReturning && this.returnPos != null) {
                Vec3 distanceVec = this.m_20182_().m_82546_(this.returnPos);
                double length = distanceVec.m_82553_();
                if (length < 5.0) {
                    this.m_20334_(-distanceVec.f_82479_ / length, -distanceVec.f_82480_ / length, -distanceVec.f_82481_ / length);
                } else {
                    Vec3 motion = this.m_20184_().m_82520_(-0.1 * (distanceVec.f_82479_ / length), -0.1 * (distanceVec.f_82480_ / length), -0.1 * (distanceVec.f_82481_ / length));
                    this.m_20256_(motion);
                }
            }
            ItemStack weaponItem = this.getWeaponItem();
            int collectorangLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLECTORANG.get()), (ItemStack)weaponItem);
            if (this.caughtItems < collectorangLevel && !(catchableEntities = this.f_19853_.m_6249_((Entity)this, aabb = this.m_142469_().m_82377_(1.0, 1.0, 1.0), ITEMS_AND_XP)).isEmpty()) {
                for (Entity entity : catchableEntities) {
                    entity.m_7998_((Entity)this, true);
                    ++this.caughtItems;
                    if (this.caughtItems < collectorangLevel) continue;
                    break;
                }
            }
            if (this.ticksUntilSound <= 0 && !this.m_36797_()) {
                this.ticksUntilSound = 5;
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlySound(), SoundSource.NEUTRAL, 2.0f, 0.5f);
                }
            }
            --this.ticksUntilSound;
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ > 200) {
            if ((Byte)this.m_20088_().m_135370_(DATA_RETURN) > 0 && !this.m_36797_()) {
                this.m_36790_(true);
            } else if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                this.dropAsItem();
                this.m_146870_();
            }
        }
        if (this.f_19853_.f_46443_ && !this.f_36703_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_7761_(LivingEntity living) {
        this.isReturning = true;
    }

    @Override
    protected void m_8060_(BlockHitResult hitResult) {
        if (this.m_20068_()) {
            BlockPos blockPos = hitResult.m_82425_();
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            Vec3i faceNormali = hitResult.m_82434_().m_122436_();
            Vec3 faceNormalVec = new Vec3((double)faceNormali.m_123341_(), (double)faceNormali.m_123342_(), (double)faceNormali.m_123343_());
            Vec3 motionVec = this.m_20184_();
            faceNormalVec.m_82541_();
            Vec3 reflectVec = faceNormalVec.m_82490_(2.0 * motionVec.m_82526_(faceNormalVec)).m_82546_(motionVec);
            this.m_20256_(reflectVec.m_82490_(-0.75));
            this.m_5496_(this.getBounceSound(), 1.0f, 2.2f / this.f_19796_.nextFloat() * 0.2f + 0.9f);
            if (blockState.m_60767_() != Material.f_76296_) {
                blockState.m_60669_(this.f_19853_, blockState, hitResult, (Projectile)this);
            }
        } else {
            super.m_8060_(hitResult);
        }
    }

    public double m_6048_() {
        return 0.0;
    }

    public void m_7332_(Entity entityIn) {
        this.positionRider(entityIn, Entity::m_6034_);
    }

    private void positionRider(Entity entityIn, Entity.MoveFunction moveIn) {
        if (this.m_20363_(entityIn)) {
            List passengers = this.m_20197_();
            for (int i = 0; i < passengers.size(); ++i) {
                if (entityIn != passengers.get(i)) continue;
                double yOff = this.m_20186_() + this.m_6048_() + entityIn.m_6049_() + (double)i * 0.5;
                moveIn.m_20372_(entityIn, this.m_20185_(), yOff, this.m_20189_());
                break;
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ReturnPosition")) {
            CompoundTag returnPosNBT = compound.m_128469_("ReturnPosition");
            if (!returnPosNBT.m_128456_()) {
                double x = returnPosNBT.m_128459_("X");
                double y = returnPosNBT.m_128459_("Y");
                double z = returnPosNBT.m_128459_("Z");
                this.returnPos = new Vec3(x, y, z);
            } else {
                this.returnPos = null;
            }
            this.maxDistance = compound.m_128459_("DistanceToReturn");
        } else {
            this.returnPos = null;
        }
        this.isReturning = compound.m_128471_("Returning");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.returnPos != null) {
            CompoundTag returnPosNBT = new CompoundTag();
            returnPosNBT.m_128347_("X", this.returnPos.f_82479_);
            returnPosNBT.m_128347_("Y", this.returnPos.f_82480_);
            returnPosNBT.m_128347_("Z", this.returnPos.f_82481_);
            compound.m_128365_("ReturnPosition", (Tag)returnPosNBT);
            compound.m_128347_("DistanceToReturn", this.maxDistance);
        } else {
            compound.m_128473_("ReturnPosition");
        }
        compound.m_128379_("Returning", this.isReturning);
    }

    @Override
    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter.m_7306_(entityHit);
    }

    @Override
    protected SoundEvent m_7239_() {
        return (SoundEvent)ModSounds.BOOMERANG_HIT_GROUND.get();
    }

    @Override
    protected SoundEvent getMobHitSound() {
        return (SoundEvent)ModSounds.BOOMERANG_HIT_MOB.get();
    }

    protected SoundEvent getFlySound() {
        return (SoundEvent)ModSounds.BOOMERANG_FLY.get();
    }

    protected SoundEvent getBounceSound() {
        return (SoundEvent)ModSounds.BOOMERANG_BOUNCE.get();
    }
}

