/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.inventory;

import com.oblivioussp.spartanweaponry.inventory.SlotFiltered;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public abstract class QuiverBaseMenu
extends AbstractContainerMenu {
    protected final ItemStack quiverStack;
    protected final IItemHandler handler;
    protected final Predicate<ItemStack> slotFilter;
    protected final ResourceLocation emptySlotTexture;
    protected int playerInvStart;
    protected int playerInvEnd;
    protected int hotbarStart;
    protected int hotbarEnd;

    protected QuiverBaseMenu(MenuType<?> type, int id, Inventory inventory, ItemStack quiverStackIn, Predicate<ItemStack> slotFilterIn, ResourceLocation emptySlotTextureIn) {
        super(type, id);
        this.slotFilter = slotFilterIn;
        this.quiverStack = quiverStackIn;
        this.emptySlotTexture = emptySlotTextureIn;
        this.handler = (IItemHandler)this.quiverStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElseThrow();
        this.playerInvStart = this.handler.getSlots();
        this.playerInvEnd = this.playerInvStart + 26;
        this.hotbarStart = this.playerInvEnd + 1;
        this.hotbarEnd = this.hotbarStart + 8;
        this.addQuiverSlots();
        this.addPlayerSlots(inventory);
    }

    protected void addQuiverSlots() {
        int slotStartX = 53;
        int slotStartY = 20;
        int columns = 1;
        switch (this.handler.getSlots()) {
            case 4: {
                columns = 4;
                slotStartX = 53;
                break;
            }
            case 6: {
                columns = 6;
                slotStartX = 35;
                break;
            }
            case 9: {
                columns = 9;
                slotStartX = 8;
                break;
            }
            case 12: {
                columns = 6;
                slotStartX = 35;
            }
        }
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.m_38897_(new SlotFiltered(this.handler, i, slotStartX + 18 * (i % columns), slotStartY + Mth.m_14143_((float)(i / columns)) * 18, this.slotFilter).setBackground(InventoryMenu.f_39692_, this.emptySlotTexture));
        }
    }

    protected void addPlayerSlots(Inventory inventory) {
        int i;
        int yOffset = this.handler.getSlots() == 12 ? 18 : 0;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, 9 + i * 9 + j, 8 + j * 18, 51 + yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 109 + yOffset));
        }
        this.m_38897_(new Slot((Container)inventory, 40, -21, this.handler.getSlots() == 12 ? 127 : 109).setBackground(InventoryMenu.f_39692_, InventoryMenu.f_39697_));
    }

    public ItemStack m_7648_(Player player, int slotIdx) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIdx);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (slotIdx >= 0 && slotIdx < this.handler.getSlots() ? !this.m_38903_(slotStack, this.playerInvStart, this.hotbarEnd + 2, false) : slotIdx >= this.playerInvStart && slotIdx <= this.hotbarEnd + 1 && slot.m_5857_(stack) && !this.m_38903_(slotStack, 0, this.playerInvStart, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return stack;
    }

    public void m_150399_(int slot, int dragType, ClickType clickType, Player player) {
        if (slot >= 0 && this.m_38853_(slot) != null && this.m_38853_(slot).m_7993_().equals(this.quiverStack, false)) {
            return;
        }
        super.m_150399_(slot, dragType, clickType, player);
    }

    public ItemStack getQuiverStack() {
        return this.quiverStack;
    }

    protected static ItemStack findQuiverStack(Inventory inventory, QuiverBaseItem.SlotType slotType, int slot) {
        ItemStack quiverStack = ItemStack.f_41583_;
        switch (slotType) {
            case HOTBAR: {
                quiverStack = inventory.m_8020_(slot);
                break;
            }
            case CURIO: {
                Optional opt = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)inventory.f_35978_, stack -> stack.m_41720_() instanceof QuiverBaseItem);
                if (!opt.isPresent()) break;
                quiverStack = ((SlotResult)opt.get()).stack();
                break;
            }
            case MAIN_HAND: {
                quiverStack = inventory.f_35978_.m_21205_();
                break;
            }
            case OFF_HAND: {
                quiverStack = inventory.f_35978_.m_21206_();
                break;
            }
        }
        return quiverStack;
    }
}

