/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.VersatileWeaponTrait;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.util.ClientConfig;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class SwordBaseItem
extends SwordItem
implements IWeaponTraitContainer<SwordBaseItem>,
IReloadable {
    protected float f_43266_ = 1.0f;
    protected double attackSpeed = 0.0;
    protected WeaponMaterial material;
    protected String customDisplayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected Multimap<Attribute, AttributeModifier> modifiers;
    protected final WeaponArchetype archetype;
    protected List<WeaponTrait> traits = ImmutableList.of();

    public SwordBaseItem(Item.Properties prop, WeaponMaterial materialIn, WeaponArchetype archetypeIn, float weaponBaseDamage, float weaponDamageMultiplier, double weaponSpeed) {
        super((Tier)materialIn, 3, -2.4f, prop.m_41503_(materialIn.m_6609_()));
        this.material = materialIn;
        this.archetype = archetypeIn;
        this.setAttackDamageAndSpeed(weaponBaseDamage, weaponDamageMultiplier, weaponSpeed);
        ReloadableHandler.addToReloadList(this);
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerMeleeWeaponPropertyOverrides(this);
        }
    }

    public SwordBaseItem(Item.Properties prop, WeaponMaterial materialIn, WeaponArchetype archetypeIn, float weaponBaseDamage, float weaponDamageMultiplier, double weaponSpeed, String customDisplayNameIn) {
        this(prop, materialIn, archetypeIn, weaponBaseDamage, weaponDamageMultiplier, weaponSpeed);
        if (materialIn.useCustomDisplayName()) {
            this.customDisplayName = customDisplayNameIn;
        }
    }

    @Override
    public void reload() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.archetype.getTraits());
        builder.addAll(this.material.getBonusTraits());
        this.traits = builder.build();
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        mapBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getDirectAttackDamage(), AttributeModifier.Operation.ADDITION));
        mapBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        if (this.traits != null) {
            this.traits.forEach(trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onModifyAttributesMelee((ImmutableMultimap.Builder<Attribute, AttributeModifier>)mapBuilder)));
        }
        this.modifiers = mapBuilder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return this.modifiers != null && equipmentSlot == EquipmentSlot.MAINHAND ? this.modifiers : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.traits != null) {
                this.traits.forEach(trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onItemUpdate(this.material, stack, level, living, itemSlot, isSelected)));
            }
        }
    }

    public float m_43299_() {
        return this.material.m_6631_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.m_6609_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        for (WeaponTrait trait : this.getAllWeaponTraitsWithType("versatile")) {
            VersatileWeaponTrait versatileTrait = (VersatileWeaponTrait)trait;
            if (!state.m_204336_(versatileTrait.getEffectiveBlocks())) continue;
            return this.material.m_6624_();
        }
        if (this.archetype.isBladed() && state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.hasWeaponTrait((WeaponTrait)((Object)WeaponTraits.SHIELD_BREACH.get()));
    }

    public Component m_7626_(ItemStack stack) {
        if (this.customDisplayName == null) {
            return super.m_7626_(stack);
        }
        return new TranslatableComponent(this.customDisplayName, new Object[]{this.material.translateName()});
    }

    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean isShiftPressed = Screen.m_96638_();
        if (this.doCraftCheck && levelIn != null) {
            ITagManager tagManager;
            if (!(((Boolean)ClientConfig.INSTANCE.forceDisableUncraftableTooltips.get()).booleanValue() || this.material.getModId() != "spartanweaponry" || (tagManager = ForgeRegistries.ITEMS.tags()).isKnownTagName(this.material.getRepairTag()) && !tagManager.getTag(this.material.getRepairTag()).isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.uncraftable_missing_material", "spartanweaponry"), new Object[]{this.material.getRepairTagName()}).m_130940_(ChatFormatting.RED));
        }
        this.archetype.addTagErrorTooltip(stack, tooltip);
        this.material.addTagErrorTooltip(stack, tooltip);
        if (this.traits != null && !this.traits.isEmpty()) {
            if (isShiftPressed) {
                tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslatableComponent("tooltip.spartanweaponry.showing_details").m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslatableComponent("tooltip.spartanweaponry.show_details", new Object[]{ChatFormatting.AQUA.toString() + "SHIFT"}).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            }
            this.archetype.addTraitsToTooltip(stack, tooltip, isShiftPressed);
        }
        tooltip.add((Component)new TextComponent(""));
        if (this.material.hasAnyBonusTraits()) {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.trait.material_bonus", "spartanweaponry")).m_130940_(ChatFormatting.AQUA));
            this.material.addTraitsToTooltip(stack, tooltip, isShiftPressed);
        }
        super.m_7373_(stack, levelIn, tooltip, flagIn);
    }

    public float getDirectAttackDamage() {
        return this.f_43266_;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.traits.forEach(trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onHitEntity(this.material, stack, target, attacker, null)));
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResult m_6225_(UseOnContext contextIn) {
        WeaponTrait trait;
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        if (actionTrait.isPresent() && (trait = actionTrait.get()).getActionCallback().isPresent()) {
            return trait.getActionCallback().get().useOn(contextIn);
        }
        return super.m_6225_(contextIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player player, InteractionHand hand) {
        WeaponTrait trait;
        ItemStack stack = player.m_21120_(hand);
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        if (actionTrait.isPresent() && (trait = actionTrait.get()).getActionCallback().isPresent()) {
            return trait.getActionCallback().get().use(stack, levelIn, player, hand);
        }
        return super.m_7203_(levelIn, player, hand);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        actionTrait.ifPresent(trait -> trait.getActionCallback().ifPresent(callback -> callback.releaseUsing(stack, level, entityLiving, timeLeft, this.getDirectAttackDamage())));
        super.m_5551_(stack, level, entityLiving, timeLeft);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        actionTrait.ifPresent(trait -> trait.getActionCallback().ifPresent(callback -> callback.onUsingTick(stack, player, count, this.getDirectAttackDamage())));
        super.onUsingTick(stack, player, count);
    }

    public int m_8105_(ItemStack stack) {
        WeaponTrait trait;
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        if (actionTrait.isPresent() && (trait = actionTrait.get()).getActionCallback().isPresent()) {
            return trait.getActionCallback().get().getUseDuration(stack);
        }
        return super.m_8105_(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        WeaponTrait trait;
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        if (actionTrait.isPresent() && (trait = actionTrait.get()).getActionCallback().isPresent()) {
            return trait.getActionCallback().get().getUseAnimation(stack);
        }
        return super.m_6164_(stack);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        WeaponTrait trait;
        Optional<WeaponTrait> actionTrait = this.archetype.getActionTrait();
        if (actionTrait.isPresent() && (trait = actionTrait.get()).getActionCallback().isPresent()) {
            return trait.getActionCallback().get().doesSneakBypassUse(stack, level, pos, player);
        }
        return super.doesSneakBypassUse(stack, level, pos, player);
    }

    public void m_7836_(ItemStack stack, Level levelIn, Player playerIn) {
        this.traits.forEach(trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onCreateItem(this.material, stack)));
        super.m_7836_(stack, levelIn, playerIn);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            if (this.traits != null) {
                this.traits.forEach(trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onCreateItem(this.material, stack)));
            }
            items.add((Object)stack);
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        for (WeaponTrait trait : this.traits) {
            if (!trait.canPerformToolAction(stack, toolAction)) continue;
            return true;
        }
        return this.archetype.canPerformToolAction(toolAction);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        for (WeaponTrait trait : this.traits) {
            if (trait.isEnchantmentCompatible(enchantment)) {
                return true;
            }
            if (!trait.isEnchantmentIncompatible(enchantment)) continue;
            return false;
        }
        return enchantment != Enchantments.f_44983_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public SwordBaseItem getAsItem() {
        return this;
    }

    @Override
    public boolean hasWeaponTrait(WeaponTrait prop) {
        return this.traits.contains((Object)prop);
    }

    @Override
    public boolean hasWeaponTraitWithType(String type) {
        return this.traits == null ? false : this.traits.stream().anyMatch(trait -> trait.getType() == type);
    }

    @Override
    public WeaponTrait getFirstWeaponTraitWithType(String type) {
        for (WeaponTrait trait : this.traits) {
            if (trait.getType() != type) continue;
            return trait;
        }
        return null;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraitsWithType(String type) {
        if (this.traits.isEmpty()) {
            return ImmutableList.of();
        }
        return this.traits.stream().filter(trait -> trait.getType() == type).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Collection<WeaponTrait> getAllWeaponTraits() {
        return this.traits;
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    public void setAttackDamageAndSpeed(float baseDamage, float damageMultiplier, double speed) {
        this.f_43266_ = this.material.m_6631_() * damageMultiplier + baseDamage - 1.0f;
        this.attackSpeed = speed;
    }
}

