/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class QuiverUpgradeRecipe
extends UpgradeRecipe {
    public QuiverUpgradeRecipe(ResourceLocation recipeId, Ingredient base, Ingredient addition, ItemStack result) {
        super(recipeId, base, addition, result);
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack inputStack = inv.m_8020_(0);
        ItemStack outputStack = super.m_5874_(inv);
        LazyOptional inputCap = inputStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (inputCap.isPresent()) {
            LazyOptional outputCap = outputStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            if (outputCap.isPresent()) {
                IItemHandler inputHandler = (IItemHandler)inputCap.resolve().orElseThrow();
                IItemHandler outputHandler = (IItemHandler)outputCap.resolve().orElseThrow();
                for (int i = 0; i < inputHandler.getSlots(); ++i) {
                    ItemStack stack = inputHandler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    outputHandler.insertItem(i, stack, false);
                }
            } else {
                Log.error("Output ItemStack: " + outputStack.m_41786_().toString() + " doesn't contain an appropriate item handler capability to store output items to!");
            }
        }
        return outputStack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.QUIVER_UPGRADE_SMITHING.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44113_;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<QuiverUpgradeRecipe> {
        public QuiverUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient baseIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient additionIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new QuiverUpgradeRecipe(recipeId, baseIngredient, additionIngredient, resultStack);
        }

        public QuiverUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                Ingredient baseIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                Ingredient additionIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                ItemStack resultStack = buffer.m_130267_();
                return new QuiverUpgradeRecipe(recipeId, baseIngredient, additionIngredient, resultStack);
            }
            catch (Exception e) {
                Log.error("Failed to read a Quiver Upgrade Smithing Recipe from a packet!");
                throw e;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, QuiverUpgradeRecipe recipe) {
            try {
                RecipeSerializer.f_44096_.m_6178_(buffer, (Recipe)recipe);
            }
            catch (Exception e) {
                Log.error("Failed to write a Quiver Upgrade Smithing Recipe from a packet!");
                throw e;
            }
        }
    }
}

