/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.loot;

import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DecapitateLootModifier
extends LootModifier {
    private final Item skull;

    public DecapitateLootModifier(LootItemCondition[] conditionsIn, Item skullItem) {
        super(conditionsIn);
        this.skull = skullItem;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81458_)) {
            return generatedLoot;
        }
        Entity killer = (Entity)context.m_165124_(LootContextParams.f_81458_);
        if (killer instanceof LivingEntity) {
            IWeaponTraitContainer container;
            LivingEntity living = (LivingEntity)killer;
            ItemStack weapon = living.m_21205_();
            if (context.m_78933_().nextDouble() < (double)(((WeaponTrait)((Object)WeaponTraits.DECAPITATE.get())).getMagnitude() / 100.0f) && weapon.m_41720_() instanceof IWeaponTraitContainer && (container = (IWeaponTraitContainer)weapon.m_41720_()).hasWeaponTraitWithType("decapitate")) {
                ItemStack skullStack = new ItemStack((ItemLike)this.skull);
                Entity thisEntity = (Entity)context.m_165124_(LootContextParams.f_81455_);
                if (thisEntity instanceof Player) {
                    Player player = (Player)thisEntity;
                    skullStack.m_41784_().m_128359_("SkullOwner", player.m_36316_().getName());
                }
                generatedLoot.add(skullStack);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DecapitateLootModifier> {
        public DecapitateLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            Item skullItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"skull")));
            return new DecapitateLootModifier(lootConditions, skullItem);
        }

        public JsonObject write(DecapitateLootModifier instance) {
            JsonObject result = this.makeConditions(instance.conditions);
            result.addProperty("skull", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.skull).toString());
            return result;
        }
    }
}

