/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.damagesource.ArmorPiercingEntityDamageSource;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Player.class})
public class PlayerMixin {
    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getSweepingDamageRatio(Lnet/minecraft/world/entity/LivingEntity;)F"))
    private float getSweepingDamageRatio(LivingEntity entityIn) {
        IWeaponTraitContainer container;
        WeaponTrait sweepTrait;
        Log.debug("Intercepted EnchantmentHelper.getSweepingDamageRatio() method!");
        ItemStack weaponStack = entityIn.m_21205_();
        Item item = weaponStack.m_41720_();
        if (item instanceof IWeaponTraitContainer && (sweepTrait = (container = (IWeaponTraitContainer)item).getFirstWeaponTraitWithType("sweep_damage")) != null && sweepTrait.getLevel() > 1) {
            float damage = (float)entityIn.m_21133_(Attributes.f_22281_);
            float resultDamage = damage * sweepTrait.getMagnitude();
            float result = (resultDamage - 1.0f) / resultDamage * sweepTrait.getMagnitude();
            Log.debug("Base damage: " + damage + " * Magnitude: " + sweepTrait.getMagnitude() + " = Result damage: " + resultDamage + " - Overridden sweep damage ratio to " + result);
            return result;
        }
        return EnchantmentHelper.m_44821_((LivingEntity)entityIn);
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;playerAttack(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/damagesource/DamageSource;"))
    private DamageSource damagePlayerAttack(Player playerIn) {
        IWeaponTraitContainer container;
        WeaponTrait armorPiercingTrait;
        Log.debug("Intercepted DamageSource.playerAtttack() method!");
        ItemStack weaponStack = playerIn.m_21205_();
        Item item = weaponStack.m_41720_();
        if (item instanceof IWeaponTraitContainer && (armorPiercingTrait = (container = (IWeaponTraitContainer)item).getFirstWeaponTraitWithType("armour_piercing")) != null) {
            Log.debug("Set damage type to Armor Piercing");
            return new ArmorPiercingEntityDamageSource("player", (Entity)playerIn, armorPiercingTrait.getMagnitude() / 100.0f);
        }
        return DamageSource.m_19344_((Player)playerIn);
    }
}

