/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.mojang.datafixers.util.Pair;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.util.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class OilHelper {
    private static final Component NO_EFFECT = new TranslatableComponent("effect.none").m_130940_(ChatFormatting.GRAY);

    public static OilEffect getOilFromStack(ItemStack stackIn) {
        CompoundTag tag = stackIn.m_41784_().m_128469_("Oil");
        ResourceLocation oil = new ResourceLocation(tag.m_128461_("Effect"));
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        if (registry.containsKey(oil)) {
            return (OilEffect)registry.getValue(oil);
        }
        return (OilEffect)((Object)OilEffects.NONE.get());
    }

    public static ItemStack makeOilStack(OilEffect oilIn) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.WEAPON_OIL.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Effect", oilIn.getRegistryName().toString());
        stack.m_41784_().m_128365_("Oil", (Tag)tag);
        return stack;
    }

    public static Potion getPotionFromStack(ItemStack stackIn) {
        return PotionUtils.m_43577_((CompoundTag)stackIn.m_41784_().m_128469_("Oil"));
    }

    public static ItemStack makePotionOilStack(Potion potionIn) {
        ItemStack stack = OilHelper.makeOilStack((OilEffect)((Object)OilEffects.POTION.get()));
        CompoundTag tag = stack.m_41784_().m_128469_("Oil");
        tag.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)potionIn).toString());
        stack.m_41783_().m_128365_("Oil", (Tag)tag);
        return stack;
    }

    public static boolean isValidPotion(Potion potionIn) {
        boolean isValidPotion = true;
        if (potionIn.m_43488_().isEmpty() || ((List)Config.INSTANCE.potionOilBlacklist.get()).contains(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)potionIn).toString())) {
            return false;
        }
        if (((List)Config.INSTANCE.potionOilWhitelist.get()).contains(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)potionIn).toString())) {
            return true;
        }
        for (MobEffectInstance effect : potionIn.m_43488_()) {
            if (effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) continue;
            isValidPotion = false;
            break;
        }
        return isValidPotion;
    }

    public static void addPotionTooltip(ItemStack stackIn, List<Component> tooltipListIn, float durationModifierIn) {
        OilHelper.addPotionTooltip(stackIn.m_41784_().m_128469_("Oil"), tooltipListIn, durationModifierIn);
    }

    public static void addPotionTooltip(CompoundTag tagIn, List<Component> tooltipListIn, float durationModifierIn) {
        List mobEffectList = PotionUtils.m_43566_((CompoundTag)tagIn);
        ArrayList<Pair> attributeList = new ArrayList<Pair>();
        if (mobEffectList.isEmpty()) {
            tooltipListIn.add(NO_EFFECT);
        } else {
            for (MobEffectInstance mobEffectInst : mobEffectList) {
                TranslatableComponent component = new TranslatableComponent(mobEffectInst.m_19576_());
                MobEffect mobEffect = mobEffectInst.m_19544_();
                Map attributeMap = mobEffect.m_19485_();
                if (!attributeMap.isEmpty()) {
                    for (Map.Entry entry : attributeMap.entrySet()) {
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        AttributeModifier modifierCopy = new AttributeModifier(modifier.m_22214_(), mobEffect.m_7048_(mobEffectInst.m_19564_(), modifier), modifier.m_22217_());
                        attributeList.add(Pair.of((Object)((Attribute)entry.getKey()), (Object)modifierCopy));
                    }
                }
                if (mobEffectInst.m_19564_() > 0) {
                    component = new TranslatableComponent("potion.withAmplifier", new Object[]{component, new TranslatableComponent("potion.potency." + mobEffectInst.m_19564_())});
                }
                if (mobEffectInst.m_19557_() > 20) {
                    component = new TranslatableComponent("potion.withDuration", new Object[]{component, MobEffectUtil.m_19581_((MobEffectInstance)mobEffectInst, (float)durationModifierIn)});
                }
                tooltipListIn.add((Component)component.m_130940_(mobEffect.m_19483_().m_19497_()));
            }
        }
        if (!attributeList.isEmpty()) {
            tooltipListIn.add(TextComponent.f_131282_);
            tooltipListIn.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair attributePair : attributeList) {
                AttributeModifier modifier = (AttributeModifier)attributePair.getSecond();
                double amount = modifier.m_22218_();
                double modifiedValue = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier.m_22218_() : modifier.m_22218_() * 100.0;
                if (amount > 0.0) {
                    tooltipListIn.add((Component)new TranslatableComponent("attribute.modifier.plus." + modifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(modifiedValue), new TranslatableComponent(((Attribute)attributePair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltipListIn.add((Component)new TranslatableComponent("attribute.modifier.take." + modifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(modifiedValue *= -1.0), new TranslatableComponent(((Attribute)attributePair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

