/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.toolleveling.client.screen.widgets.ButtonEntry;
import com.tristankechlo.toolleveling.client.screen.widgets.ButtonListWidget;
import com.tristankechlo.toolleveling.menu.ToolLevelingTableMenu;
import com.tristankechlo.toolleveling.utils.ButtonHelper;
import java.util.List;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToolLevelingTableScreen
extends AbstractContainerScreen<ToolLevelingTableMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("toolleveling", "textures/gui/tool_leveling_table.png");
    protected ButtonListWidget buttonList;
    private byte ticksSinceUpdate = 0;

    public ToolLevelingTableScreen(ToolLevelingTableMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 248;
        this.f_97727_ = 220;
        this.f_97731_ += 52;
        --this.f_97728_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttonList = new ButtonListWidget(this, 136, this.f_97736_ + 23, this.f_97736_ + 118);
        this.buttonList.m_93507_(this.f_97735_ + 105);
        this.m_142416_((GuiEventListener)this.buttonList);
    }

    public void m_181908_() {
        this.ticksSinceUpdate = (byte)(this.ticksSinceUpdate + 1);
        if (this.ticksSinceUpdate % 5 == 0) {
            this.ticksSinceUpdate = 0;
            this.buttonList.refreshList();
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.buttonList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        for (int i = 0; i < this.buttonList.m_6702_().size(); ++i) {
            ButtonEntry entry = (ButtonEntry)((Object)this.buttonList.m_6702_().get(i));
            if (!entry.button.m_198029_()) continue;
            List<Component> tooltip = ButtonHelper.getButtonToolTips(entry);
            this.m_96597_(matrixStack, tooltip, mouseX, mouseY);
        }
        this.renderPointsSummary(matrixStack);
    }

    private void renderPointsSummary(PoseStack stack) {
        String start = "container.toolleveling.tool_leveling_table.worth.";
        TranslatableComponent bonusPoints = new TranslatableComponent(start + "bonus_points", new Object[]{((ToolLevelingTableMenu)this.f_97732_).getBonusPoints()});
        TranslatableComponent invWorth = new TranslatableComponent(start + "inv", new Object[]{((ToolLevelingTableMenu)this.f_97732_).getContainerWorth()});
        float left = this.f_97735_ + 8;
        this.f_96547_.m_92889_(stack, (Component)bonusPoints, left, (float)(this.f_97736_ + 45), 0x404040);
        this.f_96547_.m_92889_(stack, (Component)invWorth, left, (float)(this.f_97736_ + 56), 0x404040);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.buttonList.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.buttonList.m_6050_(mouseX, mouseY, delta);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mX, int my) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        ToolLevelingTableScreen.m_93133_((PoseStack)poseStack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
    }
}

