/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.client.screen.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.toolleveling.client.screen.ToolLevelingTableScreen;
import com.tristankechlo.toolleveling.menu.ToolLevelingTableMenu;
import com.tristankechlo.toolleveling.network.PacketHandler;
import com.tristankechlo.toolleveling.network.packets.SetEnchantmentToolLevelingTable;
import com.tristankechlo.toolleveling.utils.ButtonHelper;
import com.tristankechlo.toolleveling.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonEntry
extends ObjectSelectionList.Entry<ButtonEntry> {
    public Button button;
    public Enchantment enchantment;
    public String name;
    public int currentLevel;
    public long upgradeCost;
    private ButtonHelper.ButtonStatus status = ButtonHelper.ButtonStatus.NORMAL;
    private final ToolLevelingTableScreen screen;
    private static Component NARRATION = null;

    public ButtonEntry(ToolLevelingTableScreen screen, Enchantment enchantment, int level) {
        this.enchantment = enchantment;
        this.currentLevel = level;
        this.name = enchantment.m_44704_();
        this.screen = screen;
        this.upgradeCost = Utils.getEnchantmentUpgradeCost(enchantment, level + 1);
        this.button = new Button(0, 0, 121, 20, ButtonHelper.getButtonText(this), b -> PacketHandler.INSTANCE.sendToServer((Object)new SetEnchantmentToolLevelingTable(((ToolLevelingTableMenu)this.screen.m_6262_()).getPos(), this.enchantment, this.currentLevel + 1)));
    }

    public void m_6311_(PoseStack mStack, int index, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        this.button.f_93620_ = left;
        this.button.f_93621_ = top;
        long worth = ((ToolLevelingTableMenu)this.screen.m_6262_()).getContainerWorth() + ((ToolLevelingTableMenu)this.screen.m_6262_()).getBonusPoints();
        boolean normallyActive = this.upgradeCost <= worth && ButtonHelper.shouldButtonBeActive(this);
        this.button.f_93623_ = normallyActive || Utils.freeCreativeUpgrades((Player)Minecraft.m_91087_().f_91074_);
        this.button.m_6305_(mStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.button.m_6375_(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void updateButtonText() {
        this.button.m_93666_(ButtonHelper.getButtonText(this));
    }

    public Component m_142172_() {
        if (NARRATION == null) {
            NARRATION = new TranslatableComponent("screen.toolleveling.tool_leveling_table");
        }
        return NARRATION;
    }

    public void setStatus(ButtonHelper.ButtonStatus status) {
        this.status = status;
        this.updateButtonText();
    }

    public ButtonHelper.ButtonStatus getStatus() {
        return this.status;
    }
}

