/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.client.screen.widgets;

import com.tristankechlo.toolleveling.client.screen.ItemValueScreen;
import com.tristankechlo.toolleveling.client.screen.widgets.ItemValueEntry;
import com.tristankechlo.toolleveling.config.ItemValueConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemValuesListWidget
extends ObjectSelectionList<ItemValueEntry> {
    public static final int ROW_HEIGHT = 26;
    public static final int ROW_SIZE = 7;
    private final ItemValueScreen screen;
    private final int listWidth;

    public ItemValuesListWidget(ItemValueScreen screen, int listWidth, int top, int bottom) {
        super(screen.getMinecraft(), listWidth, screen.f_96544_, top, bottom, 26);
        this.screen = screen;
        this.listWidth = listWidth;
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93473_(false, 0);
        this.refreshList();
    }

    private void refreshList() {
        List entries = ItemValueConfig.itemValues.getValue().entrySet().stream().sorted((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue())).map(entry -> new Tuple((Object)new ItemStack((ItemLike)entry.getKey()), (Object)((Long)entry.getValue()))).collect(Collectors.toList());
        int partitionSize = 7;
        ArrayList partitions = new ArrayList();
        for (int i = 0; i < entries.size(); i += partitionSize) {
            partitions.add(entries.subList(i, Math.min(i + partitionSize, entries.size())));
        }
        for (List list : partitions) {
            NonNullList nonNullList = NonNullList.m_122780_((int)partitionSize, (Object)new Tuple((Object)ItemStack.f_41583_, (Object)0L));
            for (int i = 0; i < list.size(); ++i) {
                nonNullList.set(i, (Object)((Tuple)list.get(i)));
            }
            this.m_7085_((AbstractSelectionList.Entry)new ItemValueEntry(this.screen, (NonNullList<Tuple<ItemStack, Long>>)nonNullList));
        }
    }

    protected int m_5756_() {
        return this.f_93392_ - 10;
    }

    public int m_5759_() {
        return this.listWidth;
    }
}

