/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.tristankechlo.toolleveling.config.CommandConfig;
import java.util.Collection;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ItemEnchantmentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class SuperEnchantCommand {
    private static final DynamicCommandExceptionType NONLIVING_ENTITY_EXCEPTION = new DynamicCommandExceptionType(entityName -> new TranslatableComponent("commands.enchant.failed.entity", new Object[]{entityName}));
    private static final DynamicCommandExceptionType INCOMPATIBLE_ENCHANTS_EXCEPTION = new DynamicCommandExceptionType(itemName -> new TranslatableComponent("commands.superenchant.failed.incompatible", new Object[]{itemName}));
    private static final DynamicCommandExceptionType WRONG_ENCHANTS_EXCEPTION = new DynamicCommandExceptionType(itemName -> new TranslatableComponent("commands.superenchant.failed.wrong", new Object[]{itemName}));
    private static final DynamicCommandExceptionType ITEMLESS_EXCEPTION = new DynamicCommandExceptionType(entityName -> new TranslatableComponent("commands.enchant.failed.itemless", new Object[]{entityName}));
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.enchant.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"superenchant").requires(player -> player.m_6761_(3))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enchantment", (ArgumentType)ItemEnchantmentArgument.m_95260_()).executes(context -> SuperEnchantCommand.enchant((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), ItemEnchantmentArgument.m_95263_((CommandContext)context, (String)"enchantment"), 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Short.MAX_VALUE)).executes(context -> SuperEnchantCommand.enchant((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), ItemEnchantmentArgument.m_95263_((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int enchant(CommandSourceStack source, Collection<? extends Entity> targets, Enchantment enchantment, int level) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                ItemStack stack = livingentity.m_21205_();
                if (!stack.m_41619_()) {
                    if (enchantment.m_6081_(stack) || CommandConfig.allowWrongEnchantments.getValue().booleanValue()) {
                        if (EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)stack).keySet(), (Enchantment)enchantment) || CommandConfig.allowIncompatibleEnchantments.getValue().booleanValue()) {
                            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                            if (enchantments.containsKey(enchantment) && level == 0) {
                                enchantments.remove(enchantment);
                            } else {
                                enchantments.put(enchantment, level);
                            }
                            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
                            ++i;
                            continue;
                        }
                        if (targets.size() != 1) continue;
                        throw INCOMPATIBLE_ENCHANTS_EXCEPTION.create((Object)stack.m_41720_().m_7626_(stack).getString());
                    }
                    if (targets.size() != 1) continue;
                    throw WRONG_ENCHANTS_EXCEPTION.create((Object)stack.m_41720_().m_7626_(stack).getString());
                }
                if (targets.size() != 1) continue;
                throw ITEMLESS_EXCEPTION.create((Object)livingentity.m_7755_().getString());
            }
            if (targets.size() != 1) continue;
            throw NONLIVING_ENTITY_EXCEPTION.create((Object)entity.m_7755_().getString());
        }
        if (i == 0) {
            throw FAILED_EXCEPTION.create();
        }
        if (targets.size() == 1) {
            source.m_81354_((Component)new TranslatableComponent("commands.enchant.success.single", new Object[]{enchantment.m_44700_(level), targets.iterator().next().m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.enchant.success.multiple", new Object[]{enchantment.m_44700_(level), targets.size()}), true);
        }
        return i;
    }
}

