/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.ConfigIdentifier;
import com.tristankechlo.toolleveling.config.util.ConfigSyncing;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public final class ConfigManager {
    private static final File CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("toolleveling").toFile();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();

    private ConfigManager() {
    }

    public static void setup() {
        for (ConfigIdentifier config : ConfigIdentifier.values()) {
            config.setToDefault();
            File configFile = new File(CONFIG_DIR, config.getFileName());
            if (configFile.exists()) {
                ConfigManager.loadConfigFromFile(config, configFile);
                ConfigManager.writeConfigToFile(config, configFile);
                ToolLeveling.LOGGER.info("Saved the checked/corrected config: " + config.getFileName());
                continue;
            }
            ConfigManager.writeConfigToFile(config, configFile);
            ToolLeveling.LOGGER.warn("No config '{}' was found, created a new one.", (Object)config.getFileName());
        }
    }

    public static void reloadAllConfigs() {
        for (ConfigIdentifier config : ConfigIdentifier.values()) {
            File configFile = new File(CONFIG_DIR, config.getFileName());
            if (configFile.exists()) {
                ConfigManager.loadConfigFromFile(config, configFile);
                ConfigManager.writeConfigToFile(config, configFile);
                ToolLeveling.LOGGER.info("Saved the checked/corrected config: " + config.getFileName());
            } else {
                ConfigManager.writeConfigToFile(config, configFile);
                ToolLeveling.LOGGER.warn("No config '{}' was found, created a new one.", (Object)config.getFileName());
            }
            ConfigSyncing.syncOneConfigToAllClients(config);
        }
    }

    public static void resetOneConfig(ConfigIdentifier config) {
        config.setToDefault();
        File configFile = new File(CONFIG_DIR, config.getFileName());
        ConfigManager.writeConfigToFile(config, configFile);
        ToolLeveling.LOGGER.info("Config '{}' was set to default.", (Object)config.getFileName());
        ConfigSyncing.syncOneConfigToAllClients(config);
    }

    private static void writeConfigToFile(ConfigIdentifier config, File file) {
        JsonObject jsonObject = config.serialize(new JsonObject());
        String jsonString = GSON.toJson((JsonElement)jsonObject);
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(jsonString);
            writer.close();
        }
        catch (Exception e) {
            ToolLeveling.LOGGER.error("There was an error writing the config to file: " + config.getFileName());
            e.printStackTrace();
        }
    }

    private static void loadConfigFromFile(ConfigIdentifier config, File file) {
        JsonObject json = null;
        try {
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse((Reader)new FileReader(file));
            json = jsonElement.getAsJsonObject();
        }
        catch (Exception e) {
            ToolLeveling.LOGGER.error("There was an error loading the config file: " + config.getFileName());
            e.printStackTrace();
        }
        if (json != null) {
            config.deserialize(json);
            ToolLeveling.LOGGER.info("Config '{}' was successfully loaded.", (Object)config.getFileName());
        } else {
            ToolLeveling.LOGGER.error("Error loading config '{}', config hasn't been loaded.", (Object)config.getFileName());
        }
    }

    public static String getConfigPath(ConfigIdentifier identifier) {
        File configFile = new File(CONFIG_DIR, identifier.getFileName());
        return configFile.getAbsolutePath();
    }

    public static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder: " + CONFIG_DIR.getAbsolutePath());
        }
        try {
            FileWriter writer = new FileWriter(new File(CONFIG_DIR, "README.txt"));
            for (String line : ConfigManager.getReadmeContent()) {
                writer.write(line + "\n");
            }
            writer.close();
            ToolLeveling.LOGGER.info("Created README.txt in config folder.");
        }
        catch (Exception e) {
            ToolLeveling.LOGGER.error("Could not create README.txt in config folder: " + CONFIG_DIR.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private static List<String> getReadmeContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("============================================================");
        lines.add("                        IMPORTANT");
        lines.add("============================================================");
        lines.add("");
        lines.add("Before editing the config, please take a look at the wiki.");
        lines.add("You can find information about all configs, and it's options there.");
        lines.add("The wiki is located at: https://github.com/tristankechlo/ToolLeveling/wiki");
        lines.add("");
        return lines;
    }
}

