/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.values;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.AbstractConfigValue;
import com.tristankechlo.toolleveling.config.util.ConfigUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryListConfig<T extends IForgeRegistryEntry<T>>
extends AbstractConfigValue<ImmutableList<T>> {
    private final ImmutableList<T> defaultValues;
    private ImmutableList<T> values;
    private List<String> rawValues = new ArrayList<String>();
    private final Type type = new TypeToken<List<String>>(){}.getType();
    private final Gson GSON = new Gson();
    private final IForgeRegistry<T> registry;

    public RegistryListConfig(String identifier, IForgeRegistry<T> registry, List<T> defaultValues) {
        super(identifier);
        if (registry == null) {
            throw new NullPointerException("registry of the config value can't be null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("defaultValues of the config value can't be null");
        }
        this.registry = registry;
        this.defaultValues = ImmutableList.copyOf(defaultValues);
        for (IForgeRegistryEntry arg : defaultValues) {
            this.rawValues.add(registry.getKey(arg).toString());
        }
        this.values = ImmutableList.copyOf(defaultValues);
    }

    @Override
    public void setToDefault() {
        this.values = ImmutableList.copyOf(this.defaultValues);
        this.rawValues.clear();
        this.defaultValues.forEach(x -> this.rawValues.add(this.registry.getKey(x).toString()));
    }

    @Override
    public ImmutableList<T> getValue() {
        return this.values;
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        JsonElement jsonElement = this.GSON.toJsonTree(this.rawValues, this.type);
        jsonObject.add(this.getIdentifier(), jsonElement);
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        try {
            JsonElement jsonElement = jsonObject.get(this.getIdentifier());
            if (jsonElement == null) {
                this.setToDefault();
                ToolLeveling.LOGGER.warn("Error while loading the config value " + this.getIdentifier() + ", using default values instead");
                return;
            }
            this.rawValues = (List)this.GSON.fromJson(jsonElement, this.type);
            if (this.rawValues == null) {
                this.setToDefault();
                ToolLeveling.LOGGER.warn("Error while loading the config value " + this.getIdentifier() + ", using default values instead");
                return;
            }
            Iterator<String> iterator = this.rawValues.iterator();
            ArrayList<Object> parsedValues = new ArrayList<Object>();
            while (iterator.hasNext()) {
                IForgeRegistryEntry entry;
                ResourceLocation loc;
                String nextValue = iterator.next();
                if (nextValue.contains("*")) {
                    String modId = ConfigUtils.getModIdFromWildcard(nextValue);
                    if (modId != null) {
                        ToolLeveling.LOGGER.info("Found wildcard with modid: '{}' in '{}'", (Object)modId, (Object)this.getIdentifier());
                        parsedValues.addAll(ConfigUtils.getAllFromWildcard(modId, this.registry));
                        continue;
                    }
                    ToolLeveling.LOGGER.warn("Found wildcard with invalid modid '{}' in '{}'", (Object)nextValue, (Object)this.getIdentifier());
                }
                if (nextValue.startsWith("#")) {
                    TagKey<T> tagKey = ConfigUtils.getTagKeyFromTag(nextValue, this.registry);
                    if (tagKey != null) {
                        ToolLeveling.LOGGER.info("Found tag '{}' in '{}'", tagKey, (Object)this.getIdentifier());
                        parsedValues.addAll(ConfigUtils.getAllFromTag(tagKey, this.registry));
                        continue;
                    }
                    ToolLeveling.LOGGER.warn("Found tag with invalid name '{}' in '{}'", (Object)nextValue, (Object)this.getIdentifier());
                }
                if ((loc = ResourceLocation.m_135820_((String)nextValue)) != null && this.registry.containsKey(loc) && (entry = this.registry.getValue(loc)) != null) {
                    parsedValues.add(entry);
                    continue;
                }
                ToolLeveling.LOGGER.warn("Found invalid entry '{}' in '{}'", (Object)nextValue, (Object)this.getIdentifier());
                iterator.remove();
            }
            this.values = ImmutableList.copyOf(parsedValues);
        }
        catch (Exception e) {
            this.values = ImmutableList.copyOf(this.defaultValues);
            ToolLeveling.LOGGER.error("Error while loading the config value " + this.getIdentifier() + ", using default values instead");
        }
    }
}

