/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.values;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.AbstractConfigValue;
import com.tristankechlo.toolleveling.config.util.ConfigUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RegistryMapConfig<X extends IForgeRegistryEntry<X>, Y>
extends AbstractConfigValue<ImmutableMap<X, Y>> {
    private ImmutableMap<X, Y> values;
    private final ImmutableMap<X, Y> defaultValues;
    private Map<String, Y> rawValues = new HashMap<String, Y>();
    private final IForgeRegistry<X> registry;
    private static final Gson GSON = new Gson();

    public RegistryMapConfig(String identifier, IForgeRegistry<X> registry, Map<X, Y> defaultValues) {
        super(identifier);
        this.registry = registry;
        this.defaultValues = ImmutableMap.copyOf(defaultValues);
    }

    @Override
    public void setToDefault() {
        this.values = ImmutableMap.copyOf(this.defaultValues);
        this.rawValues.clear();
        this.defaultValues.forEach((x, y) -> this.rawValues.put(this.registry.getKey(x).toString(), y));
    }

    @Override
    public ImmutableMap<X, Y> getValue() {
        return this.values;
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        JsonElement jsonElement = GSON.toJsonTree(this.rawValues, this.getType());
        jsonObject.add(this.getIdentifier(), jsonElement);
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get(this.getIdentifier());
        if (jsonElement == null) {
            this.setToDefault();
            ToolLeveling.LOGGER.error("Error while loading the config value '{}', using default values instead", (Object)this.getIdentifier());
            return;
        }
        this.rawValues = (Map)GSON.fromJson(jsonElement, this.getType());
        if (this.rawValues == null) {
            this.setToDefault();
            ToolLeveling.LOGGER.error("Error while parsing the config value '{}', using default values instead", (Object)this.getIdentifier());
            return;
        }
        Iterator<Map.Entry<String, Y>> iterator = this.rawValues.entrySet().iterator();
        HashMap<IForgeRegistryEntry, Y> parsedValues = new HashMap<IForgeRegistryEntry, Y>();
        while (iterator.hasNext()) {
            ResourceLocation loc;
            List<X> entries;
            Map.Entry<String, Y> entry = iterator.next();
            Y value = entry.getValue();
            if (!this.isValueValid(value)) {
                ToolLeveling.LOGGER.warn("Removing '{}' because the value '{}' is not valid", (Object)entry.getKey(), entry.getValue());
                iterator.remove();
                continue;
            }
            if (entry.getKey().contains("*")) {
                String modid = ConfigUtils.getModIdFromWildcard(entry.getKey());
                if (modid != null) {
                    entries = ConfigUtils.getAllFromWildcard(modid, this.registry);
                    this.addAllEntries(parsedValues, entries, value);
                    ToolLeveling.LOGGER.info("Found wildcard with modid: '{}' in '{}'", (Object)modid, (Object)this.getIdentifier());
                    continue;
                }
                ToolLeveling.LOGGER.warn("Found wildcard with invalid modid '{}' in '{}'", (Object)entry.getKey(), (Object)this.getIdentifier());
            }
            if (entry.getKey().startsWith("#")) {
                TagKey<X> tagKey = ConfigUtils.getTagKeyFromTag(entry.getKey(), this.registry);
                if (tagKey != null) {
                    entries = ConfigUtils.getAllFromTag(tagKey, this.registry);
                    this.addAllEntries(parsedValues, entries, value);
                    ToolLeveling.LOGGER.info("Found tag '{}' in '{}'", (Object)tagKey.f_203868_(), (Object)this.getIdentifier());
                    continue;
                }
                ToolLeveling.LOGGER.warn("Found tag with invalid name '{}' in '{}'", (Object)entry.getKey(), (Object)this.getIdentifier());
            }
            if ((loc = ResourceLocation.m_135820_((String)entry.getKey())) != null && this.registry.containsKey(loc)) {
                IForgeRegistryEntry singleEntry = this.registry.getValue(loc);
                if (singleEntry != null && this.isKeyValid(singleEntry, loc)) {
                    parsedValues.put(singleEntry, value);
                    continue;
                }
                ToolLeveling.LOGGER.warn("Ignoring value '{}' from '{}' because it is not allowed", (Object)loc, (Object)this.getIdentifier());
            }
            ToolLeveling.LOGGER.warn("Found invalid entry '{}' in '{}'", (Object)entry.getKey(), (Object)this.getIdentifier());
            iterator.remove();
        }
        this.values = ImmutableMap.copyOf(parsedValues);
    }

    public void addAllEntries(Map<X, Y> parsedValues, List<X> entries, Y value) {
        entries.forEach(key -> {
            if (this.isKeyValid(key, this.registry.getKey(key))) {
                parsedValues.put(key, value);
            } else {
                ToolLeveling.LOGGER.warn("Ignoring value '{}' from '{}' because it is not allowed", key, (Object)this.registry.getKey(key).toString());
            }
        });
    }

    protected abstract Type getType();

    protected abstract boolean isValueValid(Y var1);

    protected abstract boolean isKeyValid(X var1, ResourceLocation var2);
}

