/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.utils;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.toolleveling.client.screen.ToolLevelingTableScreen;
import com.tristankechlo.toolleveling.client.screen.widgets.ButtonEntry;
import com.tristankechlo.toolleveling.config.ToolLevelingConfig;
import com.tristankechlo.toolleveling.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;

public final class ButtonHelper {
    public static boolean shouldButtonBeActive(ButtonEntry entry) {
        ButtonStatus status = entry.getStatus();
        if (status == ButtonStatus.NORMAL) {
            return true;
        }
        if (status == ButtonStatus.USELESS) {
            return ToolLevelingConfig.allowLevelingUselessEnchantments.getValue();
        }
        if (status == ButtonStatus.BREAK) {
            return ToolLevelingConfig.allowLevelingBreakingEnchantments.getValue();
        }
        if (status == ButtonStatus.NOT_WHITELISTED || status == ButtonStatus.BLACKLISTED || status == ButtonStatus.CAPPED || status == ButtonStatus.MAX_LEVEL || status == ButtonStatus.MIN_LEVEL) {
            return false;
        }
        return false;
    }

    public static ButtonEntry getButtonEntry(ToolLevelingTableScreen parent, Enchantment enchantment, int level) {
        ImmutableList<Enchantment> whitelist = ToolLevelingConfig.whitelist.getValue();
        ImmutableList<Enchantment> blacklist = ToolLevelingConfig.blacklist.getValue();
        ButtonEntry buttonEntry = new ButtonEntry(parent, enchantment, level);
        if (!whitelist.isEmpty() && !whitelist.contains(enchantment)) {
            buttonEntry.setStatus(ButtonStatus.NOT_WHITELISTED);
            return buttonEntry;
        }
        if (whitelist.isEmpty() && blacklist.contains(enchantment)) {
            buttonEntry.setStatus(ButtonStatus.BLACKLISTED);
            return buttonEntry;
        }
        if (level >= Short.MAX_VALUE) {
            buttonEntry.setStatus(ButtonStatus.MAX_LEVEL);
            return buttonEntry;
        }
        if (Utils.isEnchantmentAtCap(enchantment, level)) {
            buttonEntry.setStatus(ButtonStatus.CAPPED);
            return buttonEntry;
        }
        if (!Utils.isEnchantmentOverMinimum(enchantment, level)) {
            buttonEntry.setStatus(ButtonStatus.MIN_LEVEL);
            return buttonEntry;
        }
        if (enchantment.m_6586_() == 1) {
            buttonEntry.setStatus(ButtonStatus.USELESS);
            return buttonEntry;
        }
        if (Utils.willEnchantmentBreak(enchantment, level)) {
            buttonEntry.setStatus(ButtonStatus.BREAK);
            return buttonEntry;
        }
        return buttonEntry;
    }

    public static Component getButtonText(ButtonEntry entry) {
        return new TranslatableComponent(entry.name).m_130940_(ButtonHelper.getButtonTextFormatting(entry));
    }

    public static List<Component> getButtonToolTips(ButtonEntry data) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)new TranslatableComponent(data.name).m_130940_(ChatFormatting.AQUA));
        String start = "container.toolleveling.tool_leveling_table";
        if (ButtonHelper.shouldButtonBeActive(data) || Utils.freeCreativeUpgrades((Player)Minecraft.m_91087_().f_91074_)) {
            tooltip.add((Component)new TranslatableComponent("container.toolleveling.tool_leveling_table.current_level", new Object[]{data.currentLevel}).m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)new TranslatableComponent("container.toolleveling.tool_leveling_table.next_level", new Object[]{data.currentLevel + 1}).m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)new TranslatableComponent("container.toolleveling.tool_leveling_table.cost", new Object[]{data.upgradeCost}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (Utils.freeCreativeUpgrades((Player)Minecraft.m_91087_().f_91074_)) {
            tooltip.add((Component)new TranslatableComponent("container.toolleveling.tool_leveling_table.free_creative").m_130940_(ChatFormatting.GREEN));
        } else if (data.getStatus() != ButtonStatus.NORMAL) {
            tooltip.add((Component)new TranslatableComponent("container.toolleveling.tool_leveling_table.error." + data.getStatus().toString().toLowerCase()).m_130940_(ButtonHelper.getButtonTextFormatting(data)));
        }
        return tooltip;
    }

    public static ChatFormatting getButtonTextFormatting(ButtonEntry entry) {
        ChatFormatting format = ChatFormatting.RESET;
        if (Utils.freeCreativeUpgrades((Player)Minecraft.m_91087_().f_91074_)) {
            return ChatFormatting.RESET;
        }
        if (entry.getStatus() != ButtonStatus.NORMAL) {
            format = ChatFormatting.DARK_RED;
        }
        if (entry.getStatus() == ButtonStatus.USELESS) {
            format = ChatFormatting.YELLOW;
        }
        return format;
    }

    public static enum ButtonStatus {
        NORMAL,
        NOT_WHITELISTED,
        BLACKLISTED,
        USELESS,
        BREAK,
        MAX_LEVEL,
        CAPPED,
        MIN_LEVEL;

    }
}

