/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class Animator {
    protected Pose prevPose = new Pose();
    protected Pose currentPose = new Pose();
    protected final Map<LivingMotion, StaticAnimation> livingAnimations = Maps.newHashMap();
    protected LivingEntityPatch<?> entitypatch;

    public abstract void playAnimation(StaticAnimation var1, float var2);

    public abstract void playAnimationInstantly(StaticAnimation var1);

    public abstract void tick();

    public abstract void reserveAnimation(StaticAnimation var1);

    public abstract EntityState getEntityState();

    public abstract AnimationPlayer getPlayerFor(DynamicAnimation var1);

    public abstract void init();

    public abstract void poseTick();

    public final void playAnimation(int namespaceId, int id, float convertTimeModifier) {
        this.playAnimation(EpicFightMod.getInstance().animationManager.findAnimationById(namespaceId, id), convertTimeModifier);
    }

    public final void playAnimationInstantly(int namespaceId, int id) {
        this.playAnimationInstantly(EpicFightMod.getInstance().animationManager.findAnimationById(namespaceId, id));
    }

    public Pose getPose(float partialTicks) {
        return Pose.interpolatePose(this.prevPose, this.currentPose, partialTicks);
    }

    public boolean isReverse() {
        return false;
    }

    public void playDeathAnimation() {
        this.playAnimation(Animations.BIPED_DEATH, 0.0f);
    }

    public void addLivingAnimation(LivingMotion livingMotion, StaticAnimation animation) {
        this.livingAnimations.put(livingMotion, animation);
    }

    public Set<Map.Entry<LivingMotion, StaticAnimation>> getLivingAnimationEntrySet() {
        return this.livingAnimations.entrySet();
    }

    public void resetMotions() {
        this.livingAnimations.clear();
    }

    public static OpenMatrix4f getBindedJointTransformByName(Pose pose, Armature armature, String jointName) {
        return Animator.getBindedJointTransformByIndex(pose, armature, armature.searchPathIndex(jointName));
    }

    public static OpenMatrix4f getBindedJointTransformByIndex(Pose pose, Armature armature, int pathIndex) {
        armature.initializeTransform();
        return Animator.getBindedJointTransformByIndexInternal(pose, armature.getJointHierarcy(), new OpenMatrix4f(), pathIndex);
    }

    private static OpenMatrix4f getBindedJointTransformByIndexInternal(Pose pose, Joint joint, OpenMatrix4f parentTransform, int pathIndex) {
        JointTransform jt = pose.getOrDefaultTransform(joint.getName());
        OpenMatrix4f result = jt.getAnimationBindedMatrix(joint, parentTransform);
        int nextIndex = pathIndex % 10;
        return nextIndex > 0 ? Animator.getBindedJointTransformByIndexInternal(pose, joint.getSubJoints().get(nextIndex - 1), result, pathIndex / 10) : result;
    }
}

