/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ActionAnimation
extends MainFrameAnimation {
    public ActionAnimation(float convertTime, String path, Model model) {
        this(convertTime, Float.MAX_VALUE, path, model);
    }

    public ActionAnimation(float convertTime, float postDelay, String path, Model model) {
        super(convertTime, path, model);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, postDelay).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, true);
    }

    public <V> ActionAnimation addProperty(AnimationProperty.ActionAnimationProperty<V> propertyType, V value) {
        this.properties.put(propertyType, value);
        return this;
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.cancelUsingItem();
        if (this.getProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT).orElse(false).booleanValue()) {
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_, 0.0);
        }
        AnimationProperty.ActionAnimationCoordSetter actionCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN).orElse((self, entitypatch$2, transformSheet) -> transformSheet.readFrom(self.jointTransforms.get("Root")));
        ((Animator)entitypatch.getAnimator()).getPlayerFor(this).setActionAnimationCoord(this, entitypatch, actionCoordSetter);
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        this.move(entitypatch, this);
    }

    @Override
    public void linkTick(LivingEntityPatch<?> entitypatch, LinkAnimation linkAnimation) {
        this.move(entitypatch, linkAnimation);
    }

    private void move(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        if (!this.validateMovement(entitypatch, animation)) {
            return;
        }
        EntityState state = this.getState(((Animator)entitypatch.getAnimator()).getPlayerFor(this).getElapsedTime());
        if (state.inaction()) {
            LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
            Vec3f vec3 = this.getCoordVector(entitypatch, animation);
            BlockPos blockpos = new BlockPos(livingentity.m_20185_(), livingentity.m_142469_().f_82289_ - 1.0, livingentity.m_20189_());
            BlockState blockState = livingentity.f_19853_.m_8055_(blockpos);
            AttributeInstance movementSpeed = livingentity.m_21051_(Attributes.f_22279_);
            boolean soulboost = blockState.m_204336_(BlockTags.f_13080_) && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)livingentity) > 0;
            double speedFactor = soulboost ? 1.0 : (double)livingentity.f_19853_.m_8055_(blockpos).m_60734_().m_49961_();
            double moveMultiplier = this.getProperty(AnimationProperty.ActionAnimationProperty.AFFECT_SPEED).orElse(false) != false ? movementSpeed.m_22135_() / movementSpeed.m_22115_() : 1.0;
            livingentity.m_6478_(MoverType.SELF, new Vec3((double)vec3.x * moveMultiplier, (double)vec3.y, (double)vec3.z * moveMultiplier * speedFactor));
        }
    }

    private boolean validateMovement(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        if (entitypatch.isLogicalClient() ? !(livingentity instanceof LocalPlayer) : livingentity instanceof ServerPlayer) {
            return false;
        }
        if (animation instanceof LinkAnimation) {
            if (!this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
                return false;
            }
            return this.shouldMove(0.0f);
        }
        return this.shouldMove(((Animator)entitypatch.getAnimator()).getPlayerFor(animation).getElapsedTime());
    }

    private boolean shouldMove(float currentTime) {
        if (this.properties.containsKey(AnimationProperty.ActionAnimationProperty.MOVE_TIME)) {
            ActionTime[] actionTimes;
            for (ActionTime actionTime : actionTimes = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_TIME).get()) {
                if (!(actionTime.begin <= currentTime) || !(currentTime <= actionTime.end)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected void modifyPose(Pose pose, LivingEntityPatch<?> entitypatch, float time) {
        JointTransform jt = pose.getOrDefaultTransform("Root");
        Vec3f jointPosition = jt.translation();
        OpenMatrix4f toRootTransformApplied = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature().searchJointByName("Root").getLocalTrasnform().removeTranslation();
        OpenMatrix4f toOrigin = OpenMatrix4f.invert(toRootTransformApplied, null);
        Vec3f worldPosition = OpenMatrix4f.transform3v(toRootTransformApplied, jointPosition, null);
        worldPosition.x = 0.0f;
        worldPosition.y = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false && worldPosition.y > 0.0f ? 0.0f : worldPosition.y;
        worldPosition.z = 0.0f;
        OpenMatrix4f.transform3v(toOrigin, worldPosition, worldPosition);
        jointPosition.x = worldPosition.x;
        jointPosition.y = worldPosition.y;
        jointPosition.z = worldPosition.z;
    }

    @Override
    public void setLinkAnimation(Pose pose1, float convertTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        float totalTime = convertTimeModifier > 0.0f ? convertTimeModifier : 0.0f + this.convertTime;
        float nextStart = 0.0f;
        if (convertTimeModifier < 0.0f) {
            dest.startsAt = nextStart -= convertTimeModifier;
        }
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setNextAnimation(this);
        Map<String, JointTransform> data1 = pose1.getJointTransformData();
        Pose pose = this.getPoseByTime(entitypatch, nextStart, 1.0f);
        JointTransform jt = pose.getOrDefaultTransform("Root");
        Vec3f withPosition = ((Animator)entitypatch.getAnimator()).getPlayerFor(this).getActionAnimationCoord().getInterpolatedTranslation(nextStart);
        jt.translation().set(withPosition);
        Map<String, JointTransform> data2 = pose.getJointTransformData();
        for (String jointName : data1.keySet()) {
            if (!data1.containsKey(jointName) || !data2.containsKey(jointName)) continue;
            Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName)), new Keyframe(totalTime, data2.get(jointName))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.addSheet(jointName, sheet);
        }
    }

    protected Vec3f getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        TransformSheet rootCoord;
        if (!this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK).isEmpty()) {
            AnimationProperty.ActionAnimationCoordSetter actionAnimationCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK).orElse(null);
            if (animation instanceof LinkAnimation) {
                actionAnimationCoordSetter.set(animation, entitypatch, animation.jointTransforms.get("Root"));
            } else {
                ((Animator)entitypatch.getAnimator()).getPlayerFor(this).setActionAnimationCoord(this, entitypatch, actionAnimationCoordSetter);
            }
        }
        if (animation instanceof LinkAnimation) {
            rootCoord = animation.jointTransforms.get("Root");
        } else {
            rootCoord = ((Animator)entitypatch.getAnimator()).getPlayerFor(this).getActionAnimationCoord();
            if (rootCoord == null) {
                rootCoord = animation.jointTransforms.get("Root");
            }
        }
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(animation);
        JointTransform jt = rootCoord.getInterpolatedTransform(player.getElapsedTime());
        JointTransform prevJt = rootCoord.getInterpolatedTransform(player.getPrevElapsedTime());
        Vec4f currentpos = new Vec4f(jt.translation().x, jt.translation().y, jt.translation().z, 1.0f);
        Vec4f prevpos = new Vec4f(prevJt.translation().x, prevJt.translation().y, prevJt.translation().z, 1.0f);
        OpenMatrix4f rotationTransform = entitypatch.getModelMatrix(1.0f).removeTranslation();
        OpenMatrix4f localTransform = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature().searchJointByName("Root").getLocalTrasnform().removeTranslation();
        rotationTransform.mulBack(localTransform);
        currentpos.transform(rotationTransform);
        prevpos.transform(rotationTransform);
        boolean hasNoGravity = ((LivingEntity)entitypatch.getOriginal()).m_20068_();
        boolean moveVertical = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false);
        float dx = prevpos.x - currentpos.x;
        float dy = moveVertical || hasNoGravity ? currentpos.y - prevpos.y : 0.0f;
        float dz = prevpos.z - currentpos.z;
        dx = Math.abs(dx) > 1.0E-7f ? dx : 0.0f;
        float f = dz = Math.abs(dz) > 1.0E-7f ? dz : 0.0f;
        if (moveVertical && currentpos.y > 0.0f && !hasNoGravity) {
            Vec3 motion = livingentity.m_20184_();
            livingentity.m_20334_(motion.f_82479_, motion.f_82480_ <= 0.0 ? motion.f_82480_ + 0.08 : motion.f_82480_, motion.f_82481_);
        }
        return new Vec3f(dx, dy, dz);
    }

    public static class ActionTime {
        private float begin;
        private float end;

        private ActionTime(float begin, float end) {
            this.begin = begin;
            this.end = end;
        }

        public static ActionTime crate(float begin, float end) {
            return new ActionTime(begin, end);
        }
    }
}

