/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.Function;
import net.minecraft.world.damagesource.DamageSource;
import yesman.epicfight.api.utils.TypeFlexibleHashMap;

public class EntityState {
    public static final StateFactor<Boolean> TURNING_LOCKED = new StateFactor<Boolean>("turningLocked", false);
    public static final StateFactor<Boolean> MOVEMENT_LOCKED = new StateFactor<Boolean>("movementLocked", false);
    public static final StateFactor<Boolean> ATTACKING = new StateFactor<Boolean>("attacking", false);
    public static final StateFactor<Boolean> CAN_BASIC_ATTACK = new StateFactor<Boolean>("canBasicAttack", true);
    public static final StateFactor<Boolean> CAN_SKILL_EXECUTION = new StateFactor<Boolean>("canExecuteSkill", true);
    public static final StateFactor<Boolean> INACTION = new StateFactor<Boolean>("inaction", false);
    public static final StateFactor<Boolean> HURT = new StateFactor<Boolean>("hurt", false);
    public static final StateFactor<Boolean> KNOCKDOWN = new StateFactor<Boolean>("knockdown", false);
    public static final StateFactor<Boolean> COUNTER_ATTACKABLE = new StateFactor<Boolean>("counterAttackable", false);
    public static final StateFactor<Integer> PHASE_LEVEL = new StateFactor<Integer>("phaseLevel", 0);
    public static final StateFactor<Function<DamageSource, Boolean>> INVULNERABILITY_PREDICATE = new StateFactor<Function<DamageSource, Boolean>>("invulnerabilityPredicate", damagesource -> false);
    final boolean turningLocked;
    final boolean movementLocked;
    final boolean attacking;
    final boolean canBasicAttack;
    final boolean canSkillExecution;
    final boolean inaction;
    final boolean hurt;
    final boolean knockDown;
    final boolean counterAttackable;
    final int phaseLevel;
    final Function<DamageSource, Boolean> invulnerabilityChecker;
    public static final EntityState DEFAULT = new EntityState(false, false, false, true, true, false, false, false, false, 0, damagesource -> false);

    EntityState(boolean turningLocked, boolean movementLocked, boolean attacking, boolean basicAttackPossible, boolean skillExecutionPossible, boolean inaction, boolean hurt, boolean knockDown, boolean counterAttackable, int phaseLevel, Function<DamageSource, Boolean> invulnerabilityChecker) {
        this.turningLocked = turningLocked;
        this.movementLocked = movementLocked;
        this.attacking = attacking;
        this.canBasicAttack = basicAttackPossible;
        this.canSkillExecution = skillExecutionPossible;
        this.inaction = inaction;
        this.hurt = hurt;
        this.knockDown = knockDown;
        this.counterAttackable = counterAttackable;
        this.phaseLevel = phaseLevel;
        this.invulnerabilityChecker = invulnerabilityChecker;
    }

    public boolean turningLocked() {
        return this.turningLocked;
    }

    public boolean movementLocked() {
        return this.movementLocked;
    }

    public boolean attacking() {
        return this.attacking;
    }

    public boolean invulnerableTo(DamageSource damagesource) {
        return this.invulnerabilityChecker.apply(damagesource);
    }

    public boolean canBasicAttack() {
        return this.canBasicAttack;
    }

    public boolean canUseSkill() {
        return this.canSkillExecution;
    }

    public boolean inaction() {
        return this.inaction;
    }

    public boolean hurt() {
        return this.hurt;
    }

    public boolean knockDown() {
        return this.knockDown;
    }

    public boolean counterAttackable() {
        return this.counterAttackable;
    }

    public int getLevel() {
        return this.phaseLevel;
    }

    public static class StateFactor<T>
    implements TypeFlexibleHashMap.TypeKey<T> {
        String name;
        T defaultValue;

        public StateFactor(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public T getDefaultVal() {
            return this.defaultValue;
        }
    }
}

