/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientModel
extends Model {
    protected Mesh mesh;
    protected RenderProperties properties;

    public ClientModel(ResourceLocation location) {
        this(location, null);
    }

    public ClientModel(ResourceLocation location, Mesh mesh) {
        super(location);
        this.mesh = mesh;
        this.properties = RenderProperties.DEFAULT;
    }

    public boolean loadMeshAndProperties(ResourceManager resourceManager) {
        JsonModelLoader loader = new JsonModelLoader(resourceManager, this.getLocation());
        if (loader.isValidSource()) {
            ResourceLocation parent = loader.getParent();
            if (parent == null) {
                this.mesh = loader.getMesh();
            } else {
                ClientModel model = (ClientModel)ClientModels.LOGICAL_CLIENT.get(parent);
                if (model == null) {
                    throw new IllegalStateException("the parent location " + parent + " not exists!");
                }
                this.mesh = ((ClientModel)ClientModels.LOGICAL_CLIENT.get(parent)).getMesh();
            }
            this.properties = loader.getRenderProperties();
            return true;
        }
        return false;
    }

    public RenderProperties getProperties() {
        return this.properties;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void drawRawModel(PoseStack posetStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord) {
        Matrix4f matrix4f = posetStack.m_85850_().m_85861_();
        Matrix3f matrix3f = posetStack.m_85850_().m_85864_();
        Mesh mesh = this.getMesh();
        for (VertexIndicator vi : mesh.vertexIndicators) {
            int pos = vi.position * 3;
            int norm = vi.normal * 3;
            int uv = vi.uv * 2;
            Vector4f posVec = new Vector4f(mesh.positions[pos], mesh.positions[pos + 1], mesh.positions[pos + 2], 1.0f);
            Vector3f normVec = new Vector3f(mesh.noramls[norm], mesh.noramls[norm + 1], mesh.noramls[norm + 2]);
            posVec.m_123607_(matrix4f);
            normVec.m_122249_(matrix3f);
            builder.m_5954_(posVec.m_123601_(), posVec.m_123615_(), posVec.m_123616_(), r, g, b, a, mesh.uvs[uv], mesh.uvs[uv + 1], overlayCoord, packedLightIn, normVec.m_122239_(), normVec.m_122260_(), normVec.m_122269_());
        }
    }

    public void drawAnimatedModel(PoseStack posetStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = posetStack.m_85850_().m_85861_();
        Matrix3f matrix3f = posetStack.m_85850_().m_85864_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        Mesh mesh = this.getMesh();
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = poses[i].removeTranslation();
        }
        for (VertexIndicator vi : mesh.vertexIndicators) {
            int pos = vi.position * 3;
            int norm = vi.normal * 3;
            int uv = vi.uv * 2;
            Vec4f position = new Vec4f(mesh.positions[pos], mesh.positions[pos + 1], mesh.positions[pos + 2], 1.0f);
            Vec4f normal = new Vec4f(mesh.noramls[norm], mesh.noramls[norm + 1], mesh.noramls[norm + 2], 1.0f);
            Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            for (int i = 0; i < vi.joint.size(); ++i) {
                int jointIndex = vi.joint.get(i);
                int weightIndex = vi.weight.get(i);
                float weight = mesh.weights[weightIndex];
                Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], position, null).scale(weight), totalPos, totalPos);
                Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
            }
            Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
            Vector3f normVec = new Vector3f(totalNorm.x, totalNorm.y, totalNorm.z);
            posVec.m_123607_(matrix4f);
            normVec.m_122249_(matrix3f);
            builder.m_5954_(posVec.m_123601_(), posVec.m_123615_(), posVec.m_123616_(), r, g, b, a, mesh.uvs[uv], mesh.uvs[uv + 1], overlayCoord, packedLightIn, normVec.m_122239_(), normVec.m_122260_(), normVec.m_122269_());
        }
    }

    public void drawAnimatedModelNoTexture(PoseStack posetStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = posetStack.m_85850_().m_85861_();
        Matrix3f matrix3f = posetStack.m_85850_().m_85864_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        Mesh mesh = this.getMesh();
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = poses[i].removeTranslation();
        }
        for (VertexIndicator vi : mesh.vertexIndicators) {
            int pos = vi.position * 3;
            int norm = vi.normal * 3;
            Vec4f position = new Vec4f(mesh.positions[pos], mesh.positions[pos + 1], mesh.positions[pos + 2], 1.0f);
            Vec4f normal = new Vec4f(mesh.noramls[norm], mesh.noramls[norm + 1], mesh.noramls[norm + 2], 1.0f);
            Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            for (int i = 0; i < vi.joint.size(); ++i) {
                int jointIndex = vi.joint.get(i);
                int weightIndex = vi.weight.get(i);
                float weight = mesh.weights[weightIndex];
                Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], position, null).scale(weight), totalPos, totalPos);
                Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
            }
            Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
            Vector3f normVec = new Vector3f(totalNorm.x, totalNorm.y, totalNorm.z);
            posVec.m_123607_(matrix4f);
            normVec.m_122249_(matrix3f);
            builder.m_5483_((double)posVec.m_123601_(), (double)posVec.m_123615_(), (double)posVec.m_123616_());
            builder.m_85950_(r, g, b, a);
            builder.m_85969_(packedLightIn);
            builder.m_5752_();
        }
    }

    public static class RenderProperties {
        public static final RenderProperties DEFAULT = RenderProperties.builder().build();
        boolean isTransparent;

        public RenderProperties(Builder builder) {
            this.isTransparent = builder.isTransparent;
        }

        public boolean isTransparent() {
            return this.isTransparent;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            boolean isTransparent = false;

            public Builder transparency(boolean isTransparent) {
                this.isTransparent = isTransparent;
                return this;
            }

            public RenderProperties build() {
                return new RenderProperties(this);
            }
        }
    }
}

