/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.bridge.game.GameVersion;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.client.model.CustomArmorVertex;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public class CustomModelBakery {
    static int indexCount = 0;
    static final Map<ResourceLocation, ClientModel> BAKED_MODELS = Maps.newHashMap();
    static final ModelBaker HEAD = new SimpleBaker(9);
    static final ModelBaker LEFT_FEET = new SimpleBaker(5);
    static final ModelBaker RIGHT_FEET = new SimpleBaker(2);
    static final ModelBaker LEFT_ARM = new Limb(16, 17, 19, 19.0f, false);
    static final ModelBaker LEFT_ARM_CHILD = new SimpleSeparateBaker(16, 17, 19.0f);
    static final ModelBaker RIGHT_ARM = new Limb(11, 12, 14, 19.0f, false);
    static final ModelBaker RIGHT_ARM_CHILD = new SimpleSeparateBaker(11, 12, 19.0f);
    static final ModelBaker LEFT_LEG = new Limb(4, 5, 6, 6.0f, true);
    static final ModelBaker LEFT_LEG_CHILD = new SimpleSeparateBaker(4, 5, 6.0f);
    static final ModelBaker RIGHT_LEG = new Limb(1, 2, 3, 6.0f, true);
    static final ModelBaker RIGHT_LEG_CHILD = new SimpleSeparateBaker(1, 2, 6.0f);
    static final ModelBaker CHEST = new Chest();
    static final ModelBaker CHEST_CHILD = new SimpleSeparateBaker(8, 7, 18.0f);

    public static void exportModels(File resourcePackDirectory) throws IOException {
        File zipFile = new File(resourcePackDirectory, "epicfight_custom_armors.zip");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        for (Map.Entry<ResourceLocation, ClientModel> entry : BAKED_MODELS.entrySet()) {
            ZipEntry zipEntry = new ZipEntry(String.format("assets/%s/%s", entry.getValue().getLocation().m_135827_(), entry.getValue().getLocation().m_135815_()));
            Gson gson = new GsonBuilder().create();
            out.putNextEntry(zipEntry);
            out.write(gson.toJson((JsonElement)entry.getValue().getMesh().toJsonObject()).getBytes());
            out.closeEntry();
            EpicFightMod.LOGGER.info("Exported custom armor model : " + entry.getKey());
        }
        ZipEntry zipEntry = new ZipEntry("pack.mcmeta");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "epicfight_custom_armor_models");
        pack.addProperty("pack_format", (Number)PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_()));
        root.add("pack", (JsonElement)pack);
        out.putNextEntry(zipEntry);
        out.write(gson.toJson((JsonElement)root).getBytes());
        out.closeEntry();
        out.close();
    }

    public static ClientModel bakeBipedCustomArmorModel(HumanoidModel<?> model, ArmorItem armorItem, EquipmentSlot slot, boolean debuggingMode) {
        ArrayList boxes = Lists.newArrayList();
        model.f_102808_.m_171327_(0.0f, 0.0f, 0.0f);
        model.f_102809_.m_171327_(0.0f, 0.0f, 0.0f);
        model.f_102810_.m_171327_(0.0f, 0.0f, 0.0f);
        model.f_102811_.m_171327_(0.0f, 0.0f, 0.0f);
        model.f_102812_.m_171327_(0.0f, 0.0f, 0.0f);
        model.f_102813_.m_171327_(0.0f, 0.0f, 0.0f);
        model.f_102814_.m_171327_(0.0f, 0.0f, 0.0f);
        switch (slot) {
            case HEAD: {
                boxes.add(new ModelPartition(HEAD, HEAD, model.f_102808_));
                boxes.add(new ModelPartition(HEAD, HEAD, model.f_102809_));
                break;
            }
            case CHEST: {
                boxes.add(new ModelPartition(CHEST, CHEST_CHILD, model.f_102810_));
                boxes.add(new ModelPartition(RIGHT_ARM, RIGHT_ARM_CHILD, model.f_102811_));
                boxes.add(new ModelPartition(LEFT_ARM, LEFT_ARM_CHILD, model.f_102812_));
                break;
            }
            case LEGS: {
                boxes.add(new ModelPartition(CHEST, CHEST_CHILD, model.f_102810_));
                boxes.add(new ModelPartition(LEFT_LEG, LEFT_LEG_CHILD, model.f_102814_));
                boxes.add(new ModelPartition(RIGHT_LEG, RIGHT_LEG_CHILD, model.f_102813_));
                break;
            }
            case FEET: {
                boxes.add(new ModelPartition(LEFT_FEET, LEFT_FEET, model.f_102814_));
                boxes.add(new ModelPartition(RIGHT_FEET, RIGHT_FEET, model.f_102813_));
                break;
            }
            default: {
                return null;
            }
        }
        ResourceLocation rl = new ResourceLocation(armorItem.getRegistryName().m_135827_(), "armor/" + armorItem.getRegistryName().m_135815_());
        ClientModel customModel = new ClientModel(rl, CustomModelBakery.bakeMeshFromCubes(boxes, debuggingMode));
        ClientModels.LOGICAL_CLIENT.register(rl, customModel);
        BAKED_MODELS.put(armorItem.getRegistryName(), customModel);
        return customModel;
    }

    private static Mesh bakeMeshFromCubes(List<ModelPartition> partitions, boolean debuggingMode) {
        ArrayList vertices = Lists.newArrayList();
        ArrayList indices = Lists.newArrayList();
        PoseStack poseStack = new PoseStack();
        indexCount = 0;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        poseStack.m_85837_(0.0, -24.0, 0.0);
        for (ModelPartition modelpartition : partitions) {
            CustomModelBakery.bake(poseStack, modelpartition, modelpartition.part, modelpartition.partBaker, vertices, indices, debuggingMode);
        }
        return CustomArmorVertex.loadVertexInformation(vertices, ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0])));
    }

    private static void bake(PoseStack poseStack, ModelPartition modelpartition, ModelPart part, ModelBaker partBaker, List<CustomArmorVertex> vertices, List<Integer> indices, boolean debuggingMode) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)part.f_104200_, (double)part.f_104201_, (double)part.f_104202_);
        if (part.f_104205_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(part.f_104205_));
        }
        if (part.f_104204_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(part.f_104204_));
        }
        if (part.f_104203_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(part.f_104203_));
        }
        for (ModelPart.Cube cube : part.f_104212_) {
            partBaker.bakeCube(poseStack, cube, vertices, indices);
        }
        for (ModelPart childParts : part.f_104213_.values()) {
            CustomModelBakery.bake(poseStack, modelpartition, childParts, modelpartition.childBaker, vertices, indices, debuggingMode);
        }
        poseStack.m_85849_();
    }

    static void putIndexCount(List<Integer> indices, int value) {
        for (int i = 0; i < 3; ++i) {
            indices.add(value);
        }
    }

    static Direction getDirectionFromVector(Vector3f directionVec) {
        for (Direction direction : Direction.values()) {
            Vector3f direcVec = new Vector3f(Float.compare(directionVec.m_122239_(), -0.0f) == 0 ? 0.0f : directionVec.m_122239_(), directionVec.m_122260_(), directionVec.m_122269_());
            if (!direcVec.equals((Object)direction.m_122432_())) continue;
            return direction;
        }
        return null;
    }

    static ModelPart.Vertex getTranslatedVertex(ModelPart.Vertex original, Matrix4f matrix) {
        Vector4f translatedPosition = new Vector4f(original.f_104371_);
        translatedPosition.m_123607_(matrix);
        return new ModelPart.Vertex(translatedPosition.m_123601_(), translatedPosition.m_123615_(), translatedPosition.m_123616_(), original.f_104372_, original.f_104373_);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelPartition {
        final ModelBaker partBaker;
        final ModelBaker childBaker;
        final ModelPart part;

        private ModelPartition(ModelBaker partedBaker, ModelBaker childBaker, ModelPart modelRenderer) {
            this.partBaker = partedBaker;
            this.childBaker = childBaker;
            this.part = modelRenderer;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class ModelBaker {
        ModelBaker() {
        }

        public abstract void bakeCube(PoseStack var1, ModelPart.Cube var2, List<CustomArmorVertex> var3, List<Integer> var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleBaker
    extends ModelBaker {
        final int jointId;

        public SimpleBaker(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(PoseStack poseStack, ModelPart.Cube cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            for (ModelPart.Polygon quad : cube.f_104341_) {
                Vector3f norm = quad.f_104360_.m_122281_();
                norm.m_122249_(poseStack.m_85850_().m_85864_());
                for (ModelPart.Vertex vertex : quad.f_104359_) {
                    Vector4f pos = new Vector4f(vertex.f_104371_);
                    pos.m_123607_(poseStack.m_85850_().m_85861_());
                    vertices.add(new CustomArmorVertex().setPosition(new Vec3f(pos.m_123601_(), pos.m_123615_(), pos.m_123616_()).scale(0.0625f)).setNormal(new Vec3f(norm.m_122239_(), norm.m_122260_(), norm.m_122269_())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                CustomModelBakery.putIndexCount(indices, indexCount);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Limb
    extends ModelBaker {
        final int upperJoint;
        final int lowerJoint;
        final int middleJoint;
        final float yClipCoord;
        final boolean bendInFront;

        public Limb(int upperJoint, int lowerJoint, int middleJoint, float yClipCoord, boolean bendInFront) {
            this.upperJoint = upperJoint;
            this.lowerJoint = lowerJoint;
            this.middleJoint = middleJoint;
            this.yClipCoord = yClipCoord;
            this.bendInFront = bendInFront;
        }

        @Override
        public void bakeCube(PoseStack poseStack, ModelPart.Cube cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            ArrayList polygons = Lists.newArrayList();
            for (ModelPart.Polygon quad : cube.f_104341_) {
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                ModelPart.Vertex pos0 = CustomModelBakery.getTranslatedVertex(quad.f_104359_[0], matrix);
                ModelPart.Vertex pos1 = CustomModelBakery.getTranslatedVertex(quad.f_104359_[1], matrix);
                ModelPart.Vertex pos2 = CustomModelBakery.getTranslatedVertex(quad.f_104359_[2], matrix);
                ModelPart.Vertex pos3 = CustomModelBakery.getTranslatedVertex(quad.f_104359_[3], matrix);
                Direction direction = CustomModelBakery.getDirectionFromVector(quad.f_104360_);
                if (pos1.f_104371_.m_122260_() > this.yClipCoord != pos2.f_104371_.m_122260_() > this.yClipCoord) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = pos2.f_104371_.m_122260_() - pos1.f_104371_.m_122260_();
                    float textureV = pos1.f_104373_ + (pos2.f_104373_ - pos1.f_104373_) * ((this.yClipCoord - pos1.f_104371_.m_122260_()) / distance);
                    ModelPart.Vertex pos4 = new ModelPart.Vertex(pos0.f_104371_.m_122239_(), this.yClipCoord, pos0.f_104371_.m_122269_(), pos0.f_104372_, textureV);
                    ModelPart.Vertex pos5 = new ModelPart.Vertex(pos1.f_104371_.m_122239_(), this.yClipCoord, pos1.f_104371_.m_122269_(), pos1.f_104372_, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJoint;
                        lowerId = this.upperJoint;
                    } else {
                        upperId = this.upperJoint;
                        lowerId = this.lowerJoint;
                    }
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, upperId), new AnimatedVertex(pos1, upperId), new AnimatedVertex(pos5, upperId), new AnimatedVertex(pos4, upperId)}, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, lowerId), new AnimatedVertex(pos5, lowerId), new AnimatedVertex(pos2, lowerId), new AnimatedVertex(pos3, lowerId)}, direction));
                    boolean bl = hasSameZ = pos4.f_104371_.m_122269_() < 0.0f == pos5.f_104371_.m_122269_() < 0.0f;
                    boolean bl2 = hasSameZ && pos4.f_104371_.m_122269_() < 0.0f == this.bendInFront ? true : (isFront = false);
                    if (isFront) {
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.middleJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos5, this.upperJoint), new AnimatedVertex(pos4, this.upperJoint)}, 0.001f, direction));
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.lowerJoint), new AnimatedVertex(pos5, this.lowerJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos4, this.middleJoint)}, 0.001f, direction));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.f_104371_.m_122269_() > 0.0f;
                    int firstJoint = this.lowerJoint;
                    int secondJoint = this.lowerJoint;
                    int thirdJoint = startFront ? this.upperJoint : this.middleJoint;
                    int fourthJoint = startFront ? this.middleJoint : this.upperJoint;
                    int fifthJoint = this.upperJoint;
                    int sixthJoint = this.upperJoint;
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, firstJoint), new AnimatedVertex(pos5, secondJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos4, fourthJoint)}, 0.001f, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, fourthJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos5, fifthJoint), new AnimatedVertex(pos4, sixthJoint)}, 0.001f, direction));
                    continue;
                }
                int jointId = pos0.f_104371_.m_122260_() > this.yClipCoord ? this.upperJoint : this.lowerJoint;
                polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, jointId), new AnimatedVertex(pos1, jointId), new AnimatedVertex(pos2, jointId), new AnimatedVertex(pos3, jointId)}, direction));
            }
            for (AnimatedPolygon quad : polygons) {
                Vector3f norm = quad.normal.m_122281_();
                norm.m_122249_(poseStack.m_85850_().m_85864_());
                for (AnimatedVertex vertex : quad.animatedVertexPositions) {
                    Vector4f pos = new Vector4f(vertex.f_104371_);
                    vertices.add(new CustomArmorVertex().setPosition(new Vec3f(pos.m_123601_(), pos.m_123615_(), pos.m_123616_()).scale(0.0625f)).setNormal(new Vec3f(norm.m_122239_(), norm.m_122260_(), norm.m_122269_())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(vertex.jointId.m_123341_(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                CustomModelBakery.putIndexCount(indices, indexCount);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleSeparateBaker
    extends ModelBaker {
        final SimpleBaker upperBaker;
        final SimpleBaker lowerBaker;
        final float yClipCoord;

        public SimpleSeparateBaker(int upperJoint, int lowerJoint, float yClipCoord) {
            this.upperBaker = new SimpleBaker(upperJoint);
            this.lowerBaker = new SimpleBaker(lowerJoint);
            this.yClipCoord = yClipCoord;
        }

        @Override
        public void bakeCube(PoseStack poseStack, ModelPart.Cube cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            Vector4f cubeCenter = new Vector4f(cube.f_104335_ + (cube.f_104338_ - cube.f_104335_) * 0.5f, cube.f_104336_ + (cube.f_104339_ - cube.f_104336_) * 0.5f, cube.f_104337_ + (cube.f_104340_ - cube.f_104337_) * 0.5f, 1.0f);
            cubeCenter.m_123607_(poseStack.m_85850_().m_85861_());
            if (cubeCenter.m_123615_() > this.yClipCoord) {
                this.upperBaker.bakeCube(poseStack, cube, vertices, indices);
            } else {
                this.lowerBaker.bakeCube(poseStack, cube, vertices, indices);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Chest
    extends ModelBaker {
        static final float X_PLANE = 0.0f;
        static final VertexWeight[] WEIGHT_ALONG_Y = new VertexWeight[]{new VertexWeight(13.6666f, 0.23f, 0.77f), new VertexWeight(15.8333f, 0.254f, 0.746f), new VertexWeight(18.0f, 0.5f, 0.5f), new VertexWeight(20.1666f, 0.744f, 0.256f), new VertexWeight(22.3333f, 0.77f, 0.23f)};

        Chest() {
        }

        @Override
        public void bakeCube(PoseStack poseStack, ModelPart.Cube cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            ArrayList xClipPolygons = Lists.newArrayList();
            ArrayList xyClipPolygons = Lists.newArrayList();
            for (ModelPart.Polygon polygon : cube.f_104341_) {
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                ModelPart.Vertex pos0 = CustomModelBakery.getTranslatedVertex(polygon.f_104359_[0], matrix);
                ModelPart.Vertex pos1 = CustomModelBakery.getTranslatedVertex(polygon.f_104359_[1], matrix);
                ModelPart.Vertex pos2 = CustomModelBakery.getTranslatedVertex(polygon.f_104359_[2], matrix);
                ModelPart.Vertex pos3 = CustomModelBakery.getTranslatedVertex(polygon.f_104359_[3], matrix);
                Direction direction = CustomModelBakery.getDirectionFromVector(polygon.f_104360_);
                VertexWeight pos0Weight = Chest.getYClipWeight(pos0.f_104371_.m_122260_());
                VertexWeight pos1Weight = Chest.getYClipWeight(pos1.f_104371_.m_122260_());
                VertexWeight pos2Weight = Chest.getYClipWeight(pos2.f_104371_.m_122260_());
                VertexWeight pos3Weight = Chest.getYClipWeight(pos3.f_104371_.m_122260_());
                if (pos1.f_104371_.m_122239_() > 0.0f != pos2.f_104371_.m_122239_() > 0.0f) {
                    float distance = pos2.f_104371_.m_122239_() - pos1.f_104371_.m_122239_();
                    float textureU = pos1.f_104372_ + (pos2.f_104372_ - pos1.f_104372_) * ((0.0f - pos1.f_104371_.m_122239_()) / distance);
                    ModelPart.Vertex pos4 = new ModelPart.Vertex(0.0f, pos0.f_104371_.m_122260_(), pos0.f_104371_.m_122269_(), textureU, pos0.f_104373_);
                    ModelPart.Vertex pos5 = new ModelPart.Vertex(0.0f, pos1.f_104371_.m_122260_(), pos1.f_104371_.m_122269_(), textureU, pos1.f_104373_);
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f)}, direction));
                    continue;
                }
                xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
            }
            for (AnimatedPolygon polygon : xClipPolygons) {
                boolean upsideDown = polygon.animatedVertexPositions[1].f_104371_.m_122260_() > polygon.animatedVertexPositions[2].f_104371_.m_122260_();
                AnimatedVertex pos0 = upsideDown ? polygon.animatedVertexPositions[2] : polygon.animatedVertexPositions[0];
                AnimatedVertex pos1 = upsideDown ? polygon.animatedVertexPositions[3] : polygon.animatedVertexPositions[1];
                AnimatedVertex pos2 = upsideDown ? polygon.animatedVertexPositions[0] : polygon.animatedVertexPositions[2];
                AnimatedVertex pos3 = upsideDown ? polygon.animatedVertexPositions[1] : polygon.animatedVertexPositions[3];
                Direction direction = CustomModelBakery.getDirectionFromVector(polygon.normal);
                List<VertexWeight> vertexWeights = Chest.getMiddleYClipWeights(pos1.f_104371_.m_122260_(), pos2.f_104371_.m_122260_());
                ArrayList animatedVertices = Lists.newArrayList();
                animatedVertices.add(pos0);
                animatedVertices.add(pos1);
                if (vertexWeights.size() > 0) {
                    for (VertexWeight vertexWeight : vertexWeights) {
                        float distance = pos2.f_104371_.m_122260_() - pos1.f_104371_.m_122260_();
                        float textureV = pos1.f_104373_ + (pos2.f_104373_ - pos1.f_104373_) * ((vertexWeight.yClipCoord - pos1.f_104371_.m_122260_()) / distance);
                        ModelPart.Vertex pos4 = new ModelPart.Vertex(pos0.f_104371_.m_122239_(), vertexWeight.yClipCoord, pos0.f_104371_.m_122269_(), pos0.f_104372_, textureV);
                        ModelPart.Vertex pos5 = new ModelPart.Vertex(pos1.f_104371_.m_122239_(), vertexWeight.yClipCoord, pos1.f_104371_.m_122269_(), pos1.f_104372_, textureV);
                        animatedVertices.add(new AnimatedVertex(pos4, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                        animatedVertices.add(new AnimatedVertex(pos5, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                    }
                }
                animatedVertices.add(pos3);
                animatedVertices.add(pos2);
                for (int i = 0; i < (animatedVertices.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    AnimatedVertex p0 = (AnimatedVertex)((Object)animatedVertices.get(start));
                    AnimatedVertex p1 = (AnimatedVertex)((Object)animatedVertices.get(start + 1));
                    AnimatedVertex p2 = (AnimatedVertex)((Object)animatedVertices.get(start + 3));
                    AnimatedVertex p3 = (AnimatedVertex)((Object)animatedVertices.get(start + 2));
                    xyClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(p0, 8, 7, 0, p0.weight.x, p0.weight.y, 0.0f), new AnimatedVertex(p1, 8, 7, 0, p1.weight.x, p1.weight.y, 0.0f), new AnimatedVertex(p2, 8, 7, 0, p2.weight.x, p2.weight.y, 0.0f), new AnimatedVertex(p3, 8, 7, 0, p3.weight.x, p3.weight.y, 0.0f)}, direction));
                }
            }
            for (AnimatedPolygon polygon : xyClipPolygons) {
                Vector3f norm = polygon.normal.m_122281_();
                norm.m_122249_(poseStack.m_85850_().m_85864_());
                for (AnimatedVertex vertex : polygon.animatedVertexPositions) {
                    int count;
                    Vector4f pos = new Vector4f(vertex.f_104371_);
                    float weight1 = vertex.weight.x;
                    float weight2 = vertex.weight.y;
                    int joint1 = vertex.jointId.m_123341_();
                    int joint2 = vertex.jointId.m_123342_();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new CustomArmorVertex().setPosition(new Vec3f(pos.m_123601_(), pos.m_123615_(), pos.m_123616_()).scale(0.0625f)).setNormal(new Vec3f(norm.m_122239_(), norm.m_122260_(), norm.m_122269_())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                CustomModelBakery.putIndexCount(indices, indexCount);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 2);
                indexCount += 4;
            }
        }

        static VertexWeight getYClipWeight(float y) {
            if (y < Chest.WEIGHT_ALONG_Y[0].yClipCoord) {
                return new VertexWeight(y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < WEIGHT_ALONG_Y.length; ++i) {
            }
            if (index > 0) {
                VertexWeight pair = WEIGHT_ALONG_Y[index];
                return new VertexWeight(y, pair.chestWeight, pair.torsoWeight);
            }
            return new VertexWeight(y, 1.0f, 0.0f);
        }

        static List<VertexWeight> getMiddleYClipWeights(float minY, float maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (VertexWeight vertexWeight : WEIGHT_ALONG_Y) {
                if (!(vertexWeight.yClipCoord > minY) || !(maxY >= vertexWeight.yClipCoord)) continue;
                cutYs.add(vertexWeight);
            }
            return cutYs;
        }

        static class VertexWeight {
            final float yClipCoord;
            final float chestWeight;
            final float torsoWeight;

            public VertexWeight(float yClipCoord, float chestWeight, float torsoWeight) {
                this.yClipCoord = yClipCoord;
                this.chestWeight = chestWeight;
                this.torsoWeight = torsoWeight;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedPolygon {
        public final AnimatedVertex[] animatedVertexPositions;
        public final Vector3f normal;

        public AnimatedPolygon(AnimatedVertex[] positionsIn, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            this.normal = directionIn.m_122432_();
        }

        public AnimatedPolygon(AnimatedVertex[] positionsIn, float cor, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new AnimatedVertex(positionsIn[0], positionsIn[0].f_104372_, positionsIn[0].f_104373_ + cor, positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new AnimatedVertex(positionsIn[1], positionsIn[1].f_104372_, positionsIn[1].f_104373_ + cor, positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new AnimatedVertex(positionsIn[2], positionsIn[2].f_104372_, positionsIn[2].f_104373_ - cor, positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new AnimatedVertex(positionsIn[3], positionsIn[3].f_104372_, positionsIn[3].f_104373_ - cor, positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = directionIn.m_122432_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedVertex
    extends ModelPart.Vertex {
        final Vec3i jointId;
        final Vec3f weight;

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vec3i(jointId1, jointId2, jointId3), new Vec3f(weight1, weight2, weight3));
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, Vec3i ids, Vec3f weights) {
            this(posTexVertx, posTexVertx.f_104372_, posTexVertx.f_104373_, ids, weights);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, float u, float v, Vec3i ids, Vec3f weights) {
            super(posTexVertx.f_104371_.m_122239_(), posTexVertx.f_104371_.m_122260_(), posTexVertx.f_104371_.m_122269_(), u, v);
            this.jointId = ids;
            this.weight = weights;
        }
    }
}

