/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HitEntityList {
    private List<Entity> hitEntites;
    private int index = -1;

    public HitEntityList(LivingEntityPatch<?> attacker, List<Entity> entities, Priority priority) {
        this.hitEntites = priority.sortingFunction.apply(attacker, entities);
    }

    public Entity getEntity() {
        return this.hitEntites.get(this.index);
    }

    public boolean next() {
        ++this.index;
        return this.hitEntites.size() > this.index;
    }

    public static enum Priority {
        DISTANCE((attacker, list) -> {
            ArrayList distanceToAttacker = Lists.newArrayList();
            ArrayList hitEntites = Lists.newArrayList();
            block0: for (Entity entity : list) {
                int index;
                double distance = ((LivingEntity)attacker.getOriginal()).m_20280_(entity);
                for (index = 0; index < hitEntites.size(); ++index) {
                    if (!(distance < (Double)distanceToAttacker.get(index))) continue;
                    hitEntites.add(index, entity);
                    distanceToAttacker.add(index, distance);
                    continue block0;
                }
                hitEntites.add(index, entity);
                distanceToAttacker.add(index, distance);
            }
            return hitEntites;
        }),
        TARGET((attacker, list) -> {
            ArrayList distanceToAttacker = Lists.newArrayList();
            ArrayList hitEntites = Lists.newArrayList();
            block0: for (Entity entity : list) {
                int index;
                double distance = ((LivingEntity)attacker.getOriginal()).m_20280_(entity);
                if (entity.equals((Object)attacker.getTarget())) {
                    hitEntites.add(0, entity);
                    distanceToAttacker.add(0, 0.0);
                    continue;
                }
                for (index = 0; index < hitEntites.size(); ++index) {
                    if (!(distance < (Double)distanceToAttacker.get(index))) continue;
                    hitEntites.add(index, entity);
                    distanceToAttacker.add(index, distance);
                    continue block0;
                }
                hitEntites.add(index, entity);
                distanceToAttacker.add(index, distance);
            }
            return hitEntites;
        });

        BiFunction<LivingEntityPatch<?>, List<Entity>, List<Entity>> sortingFunction;

        private Priority(BiFunction<LivingEntityPatch<?>, List<Entity>, List<Entity>> sortingFunction) {
            this.sortingFunction = sortingFunction;
        }
    }
}

