/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.main.EpicFightMod;

public class Vec3f
extends Vec2f {
    public static final Vec3f X_AXIS = new Vec3f(1.0f, 0.0f, 0.0f);
    public static final Vec3f Y_AXIS = new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Vec3f Z_AXIS = new Vec3f(0.0f, 0.0f, 1.0f);
    public float z;

    public Vec3f() {
        this.z = 0.0f;
    }

    public Vec3f(float x, float y, float z) {
        super(x, y);
        this.z = z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vec3f vec3f) {
        this.x = vec3f.x;
        this.y = vec3f.y;
        this.z = vec3f.z;
    }

    public Vec3f add(float x, float y, float z) {
        return this.add(new Vec3f(x, y, z));
    }

    public Vec3f add(Vec3f vec) {
        return Vec3f.add(vec, this, this);
    }

    public static Vec3f add(Vec3f left, Vec3f right, Vec3f dest) {
        if (dest == null) {
            return new Vec3f(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        dest.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return dest;
    }

    public Vec3f sub(Vec3f vec) {
        return Vec3f.sub(this, vec, this);
    }

    public static Vec3f sub(Vec3f left, Vec3f right, Vec3f dest) {
        if (dest == null) {
            return new Vec3f(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        dest.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return dest;
    }

    public Vec3f multiply(Vec3f vec) {
        return Vec3f.multiply(this, this, vec.x, vec.y, vec.z);
    }

    public Vec3f multiply(float x, float y, float z) {
        return Vec3f.multiply(this, this, x, y, z);
    }

    public static Vec3f multiply(Vec3f src, Vec3f dest, float x, float y, float z) {
        if (dest == null) {
            dest = new Vec3f();
        }
        dest.x = src.x * x;
        dest.y = src.y * y;
        dest.z = src.z * z;
        return dest;
    }

    @Override
    public Vec3f scale(float f) {
        return Vec3f.scale(this, this, f);
    }

    public static Vec3f scale(Vec3f src, Vec3f dest, float f) {
        if (dest == null) {
            dest = new Vec3f();
        }
        dest.x = src.x * f;
        dest.y = src.y * f;
        dest.z = src.z * f;
        return dest;
    }

    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSqr());
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distanceSqr(Vec3f opponent) {
        return new Vec3f(this.x - opponent.x, this.y - opponent.y, this.z - opponent.z).lengthSqr();
    }

    public static float dot(Vec3f left, Vec3f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    public static Vec3f cross(Vec3f left, Vec3f right, Vec3f dest) {
        if (dest == null) {
            dest = new Vec3f();
        }
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    public static float getAngleBetween(Vec3f a, Vec3f b) {
        return (float)Math.acos(Math.min(1.0f, Vec3f.dot(a, b) / (a.length() * b.length())));
    }

    public static Quaternion getRotatorBetween(Vec3f a, Vec3f b) {
        Vec3f axis = Vec3f.cross(a, b, null).normalise();
        float dotDivLength = Vec3f.dot(a, b) / (a.length() * b.length());
        if (!Float.isFinite(dotDivLength)) {
            EpicFightMod.LOGGER.info("Warning : given vector's length is zero");
            new IllegalArgumentException().printStackTrace();
            dotDivLength = 1.0f;
        }
        float radian = (float)Math.acos(Math.min(1.0f, dotDivLength));
        return new Quaternion(axis.toMojangVector(), radian, false);
    }

    public Vec3f normalise() {
        float norm = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (norm != 0.0f) {
            this.x /= norm;
            this.y /= norm;
            this.z /= norm;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        }
        return this;
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Vector3f toMojangVector() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public static Vec3f fromMojangVector(Vector3f vec3) {
        return new Vec3f(vec3.m_122239_(), vec3.m_122260_(), vec3.m_122269_());
    }
}

