/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private Map<KeyMapping, BiConsumer<KeyMapping, Integer>> keyFunctions;
    private Set<Object> packets = Sets.newHashSet();
    private Minecraft minecraft;
    private LocalPlayer player;
    private LocalPlayerPatch playerpatch;
    private KeyBindingMap keyHash;
    private int mouseLeftPressCounter = 0;
    private int sneakPressCounter = 0;
    private int reservedKey;
    private int reserveCounter;
    private int lastHotbarLockedTime;
    private boolean sneakPressToggle = false;
    private boolean mouseLeftPressToggle = false;
    private boolean hotbarLocked;
    private boolean lightPress;
    public Options options;

    public ControllEngine() {
        Events.controllEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.options = this.minecraft.f_91066_;
        this.keyFunctions = Maps.newHashMap();
        this.keyFunctions.put(this.options.f_92096_, this::attackKeyPressed);
        this.keyFunctions.put(this.options.f_92093_, this::swapHandKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.SWITCH_MODE, this::switchModeKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.DODGE, this::dodgeKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.SPECIAL_SKILL, this::specialSkillKeyPressed);
        try {
            this.keyHash = (KeyBindingMap)ObfuscationReflectionHelper.findField(KeyMapping.class, (String)"f_90810_").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setPlayerPatch(LocalPlayerPatch playerpatch) {
        this.mouseLeftPressCounter = 0;
        this.mouseLeftPressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.lightPress = false;
        this.player = (LocalPlayer)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.m_108633_();
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.m_108633_();
    }

    private void attackKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode()) {
            this.setKeyBind(key, false);
            while (key.m_90859_()) {
            }
            UseAnim useAnim = this.playerpatch.getHoldingItemCapability(((LocalPlayer)this.playerpatch.getOriginal()).m_7655_()).getUseAnimation(this.playerpatch);
            if (!(this.player.m_21212_() != 0 && useAnim != UseAnim.BLOCK || this.mouseLeftPressToggle)) {
                this.mouseLeftPressToggle = true;
            }
        }
    }

    private void dodgeKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode()) {
            if (key.getKey().m_84873_() == this.options.f_92090_.getKey().m_84873_()) {
                if (this.player.m_20202_() == null && !this.sneakPressToggle) {
                    this.sneakPressToggle = true;
                }
            } else {
                SkillCategories skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillCategories.KNOCKDOWN_WAKEUP : SkillCategories.DODGE;
                SkillContainer skill = this.playerpatch.getSkill(skillCategory);
                if (skill.canExecute(this.playerpatch) && skill.getSkill().isExecutableState(this.playerpatch)) {
                    skill.sendExecuteRequest(this.playerpatch, this.packets);
                }
            }
        }
    }

    private void swapHandKeyPressed(KeyMapping key, int action) {
        if (this.playerpatch.getEntityState().inaction() || !this.playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand()) {
            while (key.m_90859_()) {
            }
            this.setKeyBind(key, false);
        }
    }

    private void switchModeKeyPressed(KeyMapping key, int action) {
        if (action == 1) {
            this.playerpatch.toggleMode();
        }
    }

    private void specialSkillKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode()) {
            if (key.getKey().m_84873_() != 0) {
                if (!this.playerpatch.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).sendExecuteRequest(this.playerpatch, this.packets)) {
                    if (!this.player.m_5833_()) {
                        this.reserveKey(SkillCategories.WEAPON_SPECIAL_ATTACK);
                    }
                } else {
                    this.lockHotkeys();
                }
            } else if (this.options.f_92096_.equals(EpicFightKeyMappings.SPECIAL_SKILL)) {
                KeyMapping.m_90835_((InputConstants.Key)this.options.f_92096_.getKey());
            }
        }
    }

    public void tick() {
        if (this.playerpatch == null) {
            return;
        }
        if (this.player.f_19797_ - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.mouseLeftPressToggle) {
            if (!this.isKeyDown(this.options.f_92096_)) {
                this.lightPress = true;
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
            } else if (EpicFightKeyMappings.SPECIAL_SKILL.getKey().equals((Object)this.options.f_92096_.getKey())) {
                if (this.mouseLeftPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                    if (!this.playerpatch.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).sendExecuteRequest(this.playerpatch, this.packets)) {
                        if (!this.player.m_5833_()) {
                            this.reserveKey(SkillCategories.WEAPON_SPECIAL_ATTACK);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.mouseLeftPressToggle = false;
                    this.mouseLeftPressCounter = 0;
                } else {
                    this.setKeyBind(this.options.f_92096_, false);
                    ++this.mouseLeftPressCounter;
                }
            }
        }
        if (this.lightPress) {
            SkillCategories slot;
            SkillCategories skillCategories = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > -0.05 ? SkillCategories.AIR_ATTACK : SkillCategories.BASIC_ATTACK;
            if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this.packets)) {
                this.player.m_36334_();
                this.lightPress = false;
                this.resetReservedKey();
                this.lockHotkeys();
            } else if (!this.player.m_5833_() && slot != SkillCategories.AIR_ATTACK) {
                this.reserveKey(slot);
            }
            this.lightPress = false;
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!this.isKeyDown(this.options.f_92090_)) {
                SkillCategories skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillCategories.KNOCKDOWN_WAKEUP : SkillCategories.DODGE;
                SkillContainer skill = this.playerpatch.getSkill(skillCategory);
                if (!skill.sendExecuteRequest(this.playerpatch, this.packets)) {
                    this.reserveKey(SkillCategories.DODGE);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.reservedKey >= 0) {
            if (this.reserveCounter > 0) {
                SkillContainer skill = this.playerpatch.getSkill(this.reservedKey);
                --this.reserveCounter;
                if (skill.getSkill() != null) {
                    if (skill.sendExecuteRequest(this.playerpatch, this.packets)) {
                        this.resetReservedKey();
                    } else {
                        this.lockHotkeys();
                    }
                }
            } else {
                this.resetReservedKey();
            }
        }
        if (this.playerpatch.getEntityState().inaction() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.f_92056_[i].m_90859_()) {
                }
            }
        }
        if (EpicFightKeyMappings.SKILL_EDIT.m_90859_() && this.playerpatch.getSkillCapability() != null) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillEditScreen(this.playerpatch.getSkillCapability()));
        }
        if (this.minecraft.m_91104_()) {
            this.minecraft.f_91067_.m_91524_(Minecraft.m_91087_().m_91268_().m_85439_());
        }
    }

    private void reserveKey(SkillCategory slot) {
        this.reservedKey = slot.universalOrdinal();
        this.reserveCounter = 8;
    }

    private void resetReservedKey() {
        this.reservedKey = -1;
        this.reserveCounter = -1;
    }

    public boolean isKeyDown(KeyMapping key) {
        if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        if (key.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        return false;
    }

    public void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.f_19797_;
        for (int i = 0; i < 9; ++i) {
            while (this.options.f_92056_[i].m_90859_()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseEvent(InputEvent.MouseInputEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Minecraft.m_91087_().f_91080_ == null) {
                InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(event.getButton());
                for (KeyMapping keybinding : Events.controllEngine.keyHash.lookupAll(input)) {
                    if (!Events.controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    Events.controllEngine.keyFunctions.get(keybinding).accept(keybinding, event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Events.controllEngine.playerpatch != null && Events.controllEngine.playerpatch.getEntityState().inaction() && Events.controllEngine.minecraft.f_91080_ == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void keyboardEvent(InputEvent.KeyInputEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Minecraft.m_91087_().f_91080_ == null) {
                InputConstants.Key input = InputConstants.Type.KEYSYM.m_84895_(event.getKey());
                for (KeyMapping keybinding : Events.controllEngine.keyHash.lookupAll(input)) {
                    if (!Events.controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    Events.controllEngine.keyFunctions.get(keybinding).accept(keybinding, event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(MovementInputUpdateEvent event) {
            if (Events.controllEngine.playerpatch == null) {
                return;
            }
            EntityState playerState = Events.controllEngine.playerpatch.getEntityState();
            if (!controllEngine.canPlayerMove(playerState)) {
                event.getInput().f_108567_ = 0.0f;
                event.getInput().f_108566_ = 0.0f;
                event.getInput().f_108568_ = false;
                event.getInput().f_108569_ = false;
                event.getInput().f_108570_ = false;
                event.getInput().f_108571_ = false;
                event.getInput().f_108572_ = false;
                event.getInput().f_108573_ = false;
                LocalPlayer clientPlayer = (LocalPlayer)event.getPlayer();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                controllEngine.setKeyBind(Events.controllEngine.options.f_92091_, false);
            }
            if (event.getPlayer().m_6084_()) {
                Events.controllEngine.playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(Events.controllEngine.playerpatch, event.getInput()));
            }
        }

        @SubscribeEvent
        public static void preProcessKeyBindings(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                if (Events.controllEngine.minecraft.f_91074_ != null) {
                    controllEngine.tick();
                }
            } else {
                for (Object packet : Events.controllEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                Events.controllEngine.packets.clear();
            }
        }
    }
}

