/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.forgeevent.RenderEnderDragonEvent;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.gui.screen.overlay.OverlayManager;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.renderer.AimHelperRenderer;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCreeperRenderer;
import yesman.epicfight.client.renderer.patched.entity.PDrownedRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEnderDragonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEndermanRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHoglinRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIllagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIronGolemRenderer;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PRavagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PSpiderRenderer;
import yesman.epicfight.client.renderer.patched.entity.PStrayRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVexRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVindicatorRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitchRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.entity.PZombieVillagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.WitherGhostCloneRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderBow;
import yesman.epicfight.client.renderer.patched.item.RenderCrossbow;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.item.RenderKatana;
import yesman.epicfight.client.renderer.patched.item.RenderShield;
import yesman.epicfight.client.renderer.patched.item.RenderTrident;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.gamerule.EpicFightGamerules;
import yesman.epicfight.world.item.EpicFightItems;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine {
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    public AimHelperRenderer aimHelper;
    private BattleModeGui guiSkillBar = new BattleModeGui(Minecraft.m_91087_());
    private Minecraft minecraft;
    private Map<EntityType<?>, Supplier<PatchedEntityRenderer>> entityRendererProvider;
    private Map<EntityType<?>, PatchedEntityRenderer> entityRendererCache;
    private Map<Item, RenderItemBase> itemRendererMapByInstance;
    private Map<Class<? extends Item>, RenderItemBase> itemRendererMapByClass;
    private FirstPersonRenderer firstPersonRenderer;
    private OverlayManager overlayManager;
    private boolean aiming;
    private int zoomOutTimer = 0;
    private int zoomCount;
    private int zoomMaxCount = 20;
    private float cameraXRot;
    private float cameraYRot;
    private float cameraXRotO;
    private float cameraYRotO;
    private boolean isPlayerRotationLocked;

    public RenderEngine() {
        Events.renderEngine = this;
        RenderItemBase.renderEngine = this;
        EntityIndicator.init();
        this.minecraft = Minecraft.m_91087_();
        this.entityRendererProvider = Maps.newHashMap();
        this.entityRendererCache = Maps.newHashMap();
        this.itemRendererMapByInstance = Maps.newHashMap();
        this.itemRendererMapByClass = Maps.newHashMap();
        this.firstPersonRenderer = new FirstPersonRenderer();
        this.overlayManager = new OverlayManager();
        this.minecraft.m_91269_().f_110093_.put(EpicFightRenderTypes.enchantedAnimatedArmor(), new BufferBuilder(EpicFightRenderTypes.enchantedAnimatedArmor().m_110507_()));
    }

    public void registerRenderer() {
        this.entityRendererProvider.put(EntityType.f_20558_, PCreeperRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20566_, PEndermanRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20501_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20530_, PZombieVillagerRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20531_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20458_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20524_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20497_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20481_, PStrayRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20532_, PPlayerRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20479_, PSpiderRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20554_, PSpiderRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20460_, PIronGolemRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20493_, PVindicatorRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20568_, PIllagerRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20495_, PWitchRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20562_, PDrownedRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20513_, PIllagerRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20518_, PRavagerRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20491_, PVexRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20511_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20512_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20456_, PHoglinRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20500_, PHoglinRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20565_, PEnderDragonRenderer::new);
        this.entityRendererProvider.put(EntityType.f_20496_, PWitherRenderer::new);
        this.entityRendererProvider.put((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get(), () -> new PWitherSkeletonMinionRenderer().setOverridingTexture("epicfight:textures/entity/wither_skeleton_minion.png"));
        this.entityRendererProvider.put((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get(), WitherGhostCloneRenderer::new);
        RenderBow bowRenderer = new RenderBow();
        RenderCrossbow crossbowRenderer = new RenderCrossbow();
        RenderShield shieldRenderer = new RenderShield();
        RenderTrident tridentRenderer = new RenderTrident();
        this.itemRendererMapByInstance.clear();
        this.itemRendererMapByInstance.put(Items.f_41852_, new RenderItemBase());
        this.itemRendererMapByInstance.put(Items.f_42411_, bowRenderer);
        this.itemRendererMapByInstance.put(Items.f_42740_, shieldRenderer);
        this.itemRendererMapByInstance.put(Items.f_42717_, crossbowRenderer);
        this.itemRendererMapByInstance.put(Items.f_42713_, tridentRenderer);
        this.itemRendererMapByInstance.put((Item)EpicFightItems.KATANA.get(), new RenderKatana());
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.aimHelper = new AimHelperRenderer();
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Add(this.entityRendererProvider, this.itemRendererMapByInstance));
        for (Map.Entry<EntityType<?>, Supplier<PatchedEntityRenderer>> entry : this.entityRendererProvider.entrySet()) {
            this.entityRendererCache.put(entry.getKey(), entry.getValue().get());
        }
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Modify(this.entityRendererCache));
    }

    public void registerCustomEntityRenderer(EntityType<?> entityType, String renderer) {
        if (renderer == "") {
            return;
        }
        EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(renderer));
        if (this.entityRendererProvider.containsKey(presetEntityType)) {
            this.entityRendererCache.put(entityType, this.entityRendererProvider.get(presetEntityType).get());
            return;
        }
        throw new IllegalArgumentException("Datapack Mob Patch Crash: Invalid Renderer type " + renderer);
    }

    public RenderItemBase getItemRenderer(Item item) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(item);
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(item.getClass());
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.f_41852_);
            }
            this.itemRendererMapByInstance.put(item, renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.getOrDefault(clazz, null);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingEntityPatch<?> entitypatch, LivingEntityRenderer<? extends Entity, ?> renderer, MultiBufferSource buffer, PoseStack matStack, int packedLightIn, float partialTicks) {
        this.getEntityRenderer((Entity)livingEntity).render(livingEntity, entitypatch, renderer, buffer, matStack, packedLightIn, partialTicks);
    }

    public PatchedEntityRenderer getEntityRenderer(Entity entity) {
        return this.entityRendererCache.get(entity.m_6095_());
    }

    public boolean hasRendererFor(Entity entity) {
        return this.entityRendererCache.computeIfAbsent(entity.m_6095_(), key -> this.entityRendererProvider.containsKey(key) ? this.entityRendererProvider.get(entity.m_6095_()).get() : null) != null;
    }

    public void clearCustomEntityRenerer() {
        this.entityRendererCache.clear();
    }

    public void zoomIn() {
        this.aiming = true;
        this.zoomCount = this.zoomCount == 0 ? 1 : this.zoomCount;
        this.zoomOutTimer = 0;
    }

    public void zoomOut(int timer) {
        this.aiming = false;
        this.zoomOutTimer = timer;
    }

    private void setRangedWeaponThirdPerson(EntityViewRenderEvent.CameraSetup event, CameraType pov, double partialTicks) {
        if (ClientEngine.instance.getPlayerPatch() == null) {
            return;
        }
        Camera camera = event.getCamera();
        Entity entity = this.minecraft.m_91288_();
        Vec3 vector = camera.m_90583_();
        double totalX = vector.m_7096_();
        double totalY = vector.m_7098_();
        double totalZ = vector.m_7094_();
        if (pov == CameraType.THIRD_PERSON_BACK) {
            double d3;
            double posX = vector.m_7096_();
            double posY = vector.m_7098_();
            double posZ = vector.m_7094_();
            double entityPosX = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * partialTicks;
            double entityPosY = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * partialTicks + (double)entity.m_20192_();
            double entityPosZ = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * partialTicks;
            float intpol = pov == CameraType.THIRD_PERSON_BACK ? (float)this.zoomCount / (float)this.zoomMaxCount : 0.0f;
            Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * intpol, RenderEngine.AIMING_CORRECTION.y * intpol, RenderEngine.AIMING_CORRECTION.z * intpol);
            OpenMatrix4f rotationMatrix = ClientEngine.instance.getPlayerPatch().getMatrix((float)partialTicks);
            Vec3f rotateVec = OpenMatrix4f.transform3v(rotationMatrix, interpolatedCorrection, null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                double d7;
                BlockHitResult raytraceresult;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = this.minecraft.f_91073_.m_45547_(new ClipContext(new Vec3(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vec3(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity))) == null || !((d7 = raytraceresult.m_82450_().m_82554_(new Vec3(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        camera.m_90584_(totalX, totalY, totalZ);
    }

    public void setCameraRotation(float x, float y) {
        float f = x * 0.15f;
        float f1 = y * 0.15f;
        if (!this.isPlayerRotationLocked) {
            this.cameraXRot = this.minecraft.f_91074_.m_146909_();
            this.cameraYRot = this.minecraft.f_91074_.m_146908_();
            this.cameraXRotO = this.minecraft.f_91074_.f_19860_;
            this.cameraYRotO = this.minecraft.f_91074_.f_19859_;
        }
        this.cameraXRot += f;
        this.cameraYRot += f1;
        this.cameraXRot = Mth.m_14036_((float)this.cameraXRot, (float)-90.0f, (float)90.0f);
        this.cameraXRotO += f;
        this.cameraYRotO += f1;
        this.cameraXRotO = Mth.m_14036_((float)this.cameraXRotO, (float)-90.0f, (float)90.0f);
        this.isPlayerRotationLocked = true;
    }

    public boolean isPlayerRotationLocked() {
        return this.isPlayerRotationLocked;
    }

    public void unlockRotation(Entity cameraEntity) {
        if (this.isPlayerRotationLocked) {
            cameraEntity.m_146926_(this.cameraXRot);
            cameraEntity.m_146922_(this.cameraYRot);
        }
        this.isPlayerRotationLocked = false;
    }

    public void correctCamera(EntityViewRenderEvent.CameraSetup event, float partialTicks) {
        if (this.isPlayerRotationLocked) {
            Camera camera = event.getCamera();
            CameraType cameraType = this.minecraft.f_91066_.m_92176_();
            float xRot = this.cameraXRotO + (this.cameraXRot - this.cameraXRotO) * partialTicks;
            float yRot = this.cameraYRotO + (this.cameraYRot - this.cameraYRotO) * partialTicks;
            if (cameraType.m_90613_()) {
                yRot += 180.0f;
                xRot *= -1.0f;
            }
            camera.m_90572_(yRot, xRot);
            event.setPitch(xRot);
            event.setYaw(yRot);
            if (!cameraType.m_90612_()) {
                Entity cameraEntity = this.minecraft.f_91075_;
                camera.m_90584_(Mth.m_14139_((double)partialTicks, (double)cameraEntity.f_19854_, (double)cameraEntity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)cameraEntity.f_19855_, (double)cameraEntity.m_20186_()) + (double)Mth.m_14179_((float)partialTicks, (float)camera.f_90563_, (float)camera.f_90562_), Mth.m_14139_((double)partialTicks, (double)cameraEntity.f_19856_, (double)cameraEntity.m_20189_()));
                camera.m_90568_(-camera.m_90566_(4.0), 0.0, 0.0);
            }
        }
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public FirstPersonRenderer getFirstPersonRenderer() {
        return this.firstPersonRenderer;
    }

    public void upSlideSkillUI() {
        this.guiSkillBar.slideUp();
    }

    public void downSlideSkillUI() {
        this.guiSkillBar.slideDown();
    }

    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
            LivingEntity livingentity = event.getEntity();
            if (renderEngine.hasRendererFor((Entity)livingentity)) {
                if (livingentity instanceof LocalPlayer && event.getPartialTick() == 1.0f) {
                    return;
                }
                LivingEntityPatch entitypatch = (LivingEntityPatch)livingentity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                if (entitypatch != null && !entitypatch.shouldSkipRender()) {
                    event.setCanceled(true);
                    renderEngine.renderEntityArmatureModel(livingentity, entitypatch, event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                }
            }
            if (!Events.renderEngine.minecraft.f_91066_.f_92062_ && !livingentity.f_19853_.m_46469_().m_46207_(EpicFightGamerules.DISABLE_ENTITY_UI)) {
                for (EntityIndicator entityIndicator : EntityIndicator.ENTITY_INDICATOR_RENDERERS) {
                    if (!entityIndicator.shouldDraw(Events.renderEngine.minecraft.f_91074_, event.getEntity())) continue;
                    entityIndicator.drawIndicator(event.getEntity(), event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
                }
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            block9: {
                LocalPlayerPatch playerpatch;
                CapabilityItem cap;
                block10: {
                    if (event.getPlayer() == null) break block9;
                    cap = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
                    playerpatch = (LocalPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (cap == null || playerpatch == null) break block9;
                    if (!ClientEngine.instance.controllEngine.isKeyDown(EpicFightKeyMappings.SPECIAL_SKILL_TOOLTIP)) break block10;
                    if (cap.getSpecialAttack(playerpatch) == null) break block9;
                    event.getToolTip().clear();
                    List<Component> skilltooltip = cap.getSpecialAttack(playerpatch).getTooltipOnItem(event.getItemStack(), cap, playerpatch);
                    for (Component s : skilltooltip) {
                        event.getToolTip().add(s);
                    }
                    break block9;
                }
                List tooltip = event.getToolTip();
                cap.modifyItemTooltip(event.getItemStack(), event.getToolTip(), playerpatch);
                for (int i = 0; i < tooltip.size(); ++i) {
                    TranslatableComponent translationComponent;
                    Component sibling;
                    Component textComp = (Component)tooltip.get(i);
                    if (textComp.m_7360_().size() <= 0 || !((sibling = (Component)textComp.m_7360_().get(0)) instanceof TranslatableComponent) || (translationComponent = (TranslatableComponent)sibling).m_131329_().length <= 1 || !(translationComponent.m_131329_()[1] instanceof TranslatableComponent)) continue;
                    CapabilityItem itemCapability = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
                    if (((TranslatableComponent)translationComponent.m_131329_()[1]).m_131328_().equals(Attributes.f_22283_.m_22087_())) {
                        float weaponSpeed = (float)((LocalPlayer)playerpatch.getOriginal()).m_21051_(Attributes.f_22283_).m_22115_();
                        for (AttributeModifier modifier : event.getItemStack().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_)) {
                            weaponSpeed = (float)((double)weaponSpeed + modifier.m_22218_());
                        }
                        if (itemCapability != null) {
                            for (AttributeModifier modifier : itemCapability.getAttributeModifiers(EquipmentSlot.MAINHAND, playerpatch).get((Object)Attributes.f_22283_)) {
                                weaponSpeed = (float)((double)weaponSpeed + modifier.m_22218_());
                            }
                        }
                        tooltip.remove(i);
                        tooltip.add(i, new TextComponent(String.format(" %.2f ", Float.valueOf(playerpatch.getModifiedAttackSpeed(cap, weaponSpeed)))).m_7220_((Component)new TranslatableComponent(Attributes.f_22283_.m_22087_())));
                        continue;
                    }
                    if (!((TranslatableComponent)translationComponent.m_131329_()[1]).m_131328_().equals(Attributes.f_22281_.m_22087_())) continue;
                    float weaponDamage = (float)((LocalPlayer)playerpatch.getOriginal()).m_21051_(Attributes.f_22281_).m_22115_();
                    weaponDamage += EnchantmentHelper.m_44833_((ItemStack)event.getItemStack(), (MobType)MobType.f_21640_);
                    for (AttributeModifier modifier : event.getItemStack().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                        weaponDamage = (float)((double)weaponDamage + modifier.m_22218_());
                    }
                    if (itemCapability != null) {
                        for (AttributeModifier modifier : itemCapability.getAttributeModifiers(EquipmentSlot.MAINHAND, playerpatch).get((Object)Attributes.f_22281_)) {
                            weaponDamage = (float)((double)weaponDamage + modifier.m_22218_());
                        }
                    }
                    tooltip.remove(i);
                    tooltip.add(i, new TextComponent(String.format(" %.0f ", Float.valueOf(playerpatch.getModifiedDamage(null, null, weaponDamage)))).m_7220_((Component)new TranslatableComponent(Attributes.f_22281_.m_22087_())).m_130940_(ChatFormatting.DARK_GREEN));
                }
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
            if (Events.renderEngine.zoomCount > 0) {
                renderEngine.setRangedWeaponThirdPerson(event, Events.renderEngine.minecraft.f_91066_.m_92176_(), event.getPartialTicks());
                if (Events.renderEngine.zoomOutTimer > 0) {
                    --Events.renderEngine.zoomOutTimer;
                } else {
                    Events.renderEngine.zoomCount = Events.renderEngine.aiming ? Events.renderEngine.zoomCount + 1 : Events.renderEngine.zoomCount - 1;
                }
                Events.renderEngine.zoomCount = Math.min(Events.renderEngine.zoomMaxCount, Events.renderEngine.zoomCount);
            }
            renderEngine.correctCamera(event, (float)event.getPartialTicks());
        }

        @SubscribeEvent
        public static void fogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        }

        @SubscribeEvent
        public static void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                Window window = Minecraft.m_91087_().m_91268_();
                LocalPlayerPatch playerpatch = ClientEngine.instance.getPlayerPatch();
                if (playerpatch != null) {
                    for (SkillContainer skillContainer : playerpatch.getSkillCapability().skillContainers) {
                        if (skillContainer.getSkill() == null) continue;
                        skillContainer.getSkill().onScreen(playerpatch, window.m_85445_(), window.m_85446_());
                    }
                    Events.renderEngine.overlayManager.renderTick(window.m_85445_(), window.m_85446_());
                    if (Minecraft.m_91404_()) {
                        Events.renderEngine.guiSkillBar.renderGui(playerpatch, event.getPartialTicks());
                    }
                }
            }
        }

        @SubscribeEvent
        public static void renderGameOverlayPost(RenderGameOverlayEvent.BossInfo event) {
            EnderDragonPatch dragonpatch;
            float stunShield;
            if (event.getBossEvent().m_18861_().getString().equals("Ender Dragon") && EnderDragonPatch.INSTANCE_CLIENT != null && (stunShield = (dragonpatch = EnderDragonPatch.INSTANCE_CLIENT).getStunShield()) > 0.0f) {
                float progression = stunShield / dragonpatch.getMaxStunShield();
                int x = event.getX();
                int y = event.getY();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)BossHealthOverlay.f_93697_);
                GuiComponent.m_93160_((PoseStack)event.getMatrixStack(), (int)x, (int)(y + 6), (int)183, (int)2, (float)0.0f, (float)45.0f, (int)182, (int)6, (int)255, (int)255);
                GuiComponent.m_93160_((PoseStack)event.getMatrixStack(), (int)(x + (int)(183.0f * progression)), (int)(y + 6), (int)((int)(183.0f * (1.0f - progression))), (int)2, (float)0.0f, (float)39.0f, (int)182, (int)6, (int)255, (int)255);
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderHandEvent event) {
            boolean isBattleMode;
            LocalPlayerPatch playerpatch = ClientEngine.instance.getPlayerPatch();
            if (playerpatch != null && ((isBattleMode = playerpatch.isBattleMode()) || !EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue().booleanValue())) {
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    Events.renderEngine.firstPersonRenderer.render((LocalPlayer)playerpatch.getOriginal(), playerpatch, (LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>>)((LivingEntityRenderer)Events.renderEngine.minecraft.m_91290_().m_114382_((Entity)((LocalPlayer)playerpatch.getOriginal()))), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTicks());
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderLevelStageEvent event) {
            if (Events.renderEngine.zoomCount > 0 && Events.renderEngine.minecraft.f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK && event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                Events.renderEngine.aimHelper.doRender(event.getPoseStack(), event.getPartialTick());
            }
        }

        @SubscribeEvent
        public static void renderEnderDragonEvent(RenderEnderDragonEvent event) {
            EnderDragonPatch entitypatch;
            EnderDragon livingentity = event.getEntity();
            if (renderEngine.hasRendererFor((Entity)livingentity) && (entitypatch = (EnderDragonPatch)livingentity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                event.setCanceled(true);
                renderEngine.getEntityRenderer((Entity)livingentity).render(livingentity, entitypatch, event.getRenderer(), event.getBuffers(), event.getPoseStack(), event.getLight(), event.getPartialRenderTick());
            }
        }
    }
}

